/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ObjectTypeEnum {
    ASSESSMENT("ASSESSMENT"),
    CONTROL_SET("CONTROL_SET"),
    CONTROL("CONTROL"),
    DELEGATION("DELEGATION"),
    ASSESSMENT_REPORT("ASSESSMENT_REPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ObjectTypeEnum> VALUE_MAP;
    private final String value;

    private ObjectTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ObjectTypeEnum> knownValues() {
        EnumSet<ObjectTypeEnum> knownValues = EnumSet.allOf(ObjectTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ObjectTypeEnum.class, ObjectTypeEnum::toString);
    }
}

