/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkGroupConfigurationUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkGroupConfigurationUpdates> {
    private static final SdkField<Boolean> ENFORCE_WORK_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::enforceWorkGroupConfiguration)).setter(WorkGroupConfigurationUpdates.setter(Builder::enforceWorkGroupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceWorkGroupConfiguration").build()}).build();
    private static final SdkField<ResultConfigurationUpdates> RESULT_CONFIGURATION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::resultConfigurationUpdates)).setter(WorkGroupConfigurationUpdates.setter(Builder::resultConfigurationUpdates)).constructor(ResultConfigurationUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfigurationUpdates").build()}).build();
    private static final SdkField<Boolean> PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::publishCloudWatchMetricsEnabled)).setter(WorkGroupConfigurationUpdates.setter(Builder::publishCloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishCloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<Long> BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::bytesScannedCutoffPerQuery)).setter(WorkGroupConfigurationUpdates.setter(Builder::bytesScannedCutoffPerQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScannedCutoffPerQuery").build()}).build();
    private static final SdkField<Boolean> REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::removeBytesScannedCutoffPerQuery)).setter(WorkGroupConfigurationUpdates.setter(Builder::removeBytesScannedCutoffPerQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveBytesScannedCutoffPerQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCE_WORK_GROUP_CONFIGURATION_FIELD, RESULT_CONFIGURATION_UPDATES_FIELD, PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD, BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD, REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enforceWorkGroupConfiguration;
    private final ResultConfigurationUpdates resultConfigurationUpdates;
    private final Boolean publishCloudWatchMetricsEnabled;
    private final Long bytesScannedCutoffPerQuery;
    private final Boolean removeBytesScannedCutoffPerQuery;

    private WorkGroupConfigurationUpdates(BuilderImpl builder) {
        this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
        this.resultConfigurationUpdates = builder.resultConfigurationUpdates;
        this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
        this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
        this.removeBytesScannedCutoffPerQuery = builder.removeBytesScannedCutoffPerQuery;
    }

    public Boolean enforceWorkGroupConfiguration() {
        return this.enforceWorkGroupConfiguration;
    }

    public ResultConfigurationUpdates resultConfigurationUpdates() {
        return this.resultConfigurationUpdates;
    }

    public Boolean publishCloudWatchMetricsEnabled() {
        return this.publishCloudWatchMetricsEnabled;
    }

    public Long bytesScannedCutoffPerQuery() {
        return this.bytesScannedCutoffPerQuery;
    }

    public Boolean removeBytesScannedCutoffPerQuery() {
        return this.removeBytesScannedCutoffPerQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceWorkGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfigurationUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishCloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeBytesScannedCutoffPerQuery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroupConfigurationUpdates)) {
            return false;
        }
        WorkGroupConfigurationUpdates other = (WorkGroupConfigurationUpdates)obj;
        return Objects.equals(this.enforceWorkGroupConfiguration(), other.enforceWorkGroupConfiguration()) && Objects.equals(this.resultConfigurationUpdates(), other.resultConfigurationUpdates()) && Objects.equals(this.publishCloudWatchMetricsEnabled(), other.publishCloudWatchMetricsEnabled()) && Objects.equals(this.bytesScannedCutoffPerQuery(), other.bytesScannedCutoffPerQuery()) && Objects.equals(this.removeBytesScannedCutoffPerQuery(), other.removeBytesScannedCutoffPerQuery());
    }

    public String toString() {
        return ToString.builder((String)"WorkGroupConfigurationUpdates").add("EnforceWorkGroupConfiguration", (Object)this.enforceWorkGroupConfiguration()).add("ResultConfigurationUpdates", (Object)this.resultConfigurationUpdates()).add("PublishCloudWatchMetricsEnabled", (Object)this.publishCloudWatchMetricsEnabled()).add("BytesScannedCutoffPerQuery", (Object)this.bytesScannedCutoffPerQuery()).add("RemoveBytesScannedCutoffPerQuery", (Object)this.removeBytesScannedCutoffPerQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnforceWorkGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enforceWorkGroupConfiguration()));
            }
            case "ResultConfigurationUpdates": {
                return Optional.ofNullable(clazz.cast(this.resultConfigurationUpdates()));
            }
            case "PublishCloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.publishCloudWatchMetricsEnabled()));
            }
            case "BytesScannedCutoffPerQuery": {
                return Optional.ofNullable(clazz.cast(this.bytesScannedCutoffPerQuery()));
            }
            case "RemoveBytesScannedCutoffPerQuery": {
                return Optional.ofNullable(clazz.cast(this.removeBytesScannedCutoffPerQuery()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkGroupConfigurationUpdates, T> g) {
        return obj -> g.apply((WorkGroupConfigurationUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enforceWorkGroupConfiguration;
        private ResultConfigurationUpdates resultConfigurationUpdates;
        private Boolean publishCloudWatchMetricsEnabled;
        private Long bytesScannedCutoffPerQuery;
        private Boolean removeBytesScannedCutoffPerQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroupConfigurationUpdates model) {
            this.enforceWorkGroupConfiguration(model.enforceWorkGroupConfiguration);
            this.resultConfigurationUpdates(model.resultConfigurationUpdates);
            this.publishCloudWatchMetricsEnabled(model.publishCloudWatchMetricsEnabled);
            this.bytesScannedCutoffPerQuery(model.bytesScannedCutoffPerQuery);
            this.removeBytesScannedCutoffPerQuery(model.removeBytesScannedCutoffPerQuery);
        }

        public final Boolean getEnforceWorkGroupConfiguration() {
            return this.enforceWorkGroupConfiguration;
        }

        @Override
        public final Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
            return this;
        }

        public final void setEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
        }

        public final ResultConfigurationUpdates.Builder getResultConfigurationUpdates() {
            return this.resultConfigurationUpdates != null ? this.resultConfigurationUpdates.toBuilder() : null;
        }

        @Override
        public final Builder resultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates;
            return this;
        }

        public final void setResultConfigurationUpdates(ResultConfigurationUpdates.BuilderImpl resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates != null ? resultConfigurationUpdates.build() : null;
        }

        public final Boolean getPublishCloudWatchMetricsEnabled() {
            return this.publishCloudWatchMetricsEnabled;
        }

        @Override
        public final Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
            return this;
        }

        public final void setPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
        }

        public final Long getBytesScannedCutoffPerQuery() {
            return this.bytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
            return this;
        }

        public final void setBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
        }

        public final Boolean getRemoveBytesScannedCutoffPerQuery() {
            return this.removeBytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder removeBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
            return this;
        }

        public final void setRemoveBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
        }

        public WorkGroupConfigurationUpdates build() {
            return new WorkGroupConfigurationUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkGroupConfigurationUpdates> {
        public Builder enforceWorkGroupConfiguration(Boolean var1);

        public Builder resultConfigurationUpdates(ResultConfigurationUpdates var1);

        default public Builder resultConfigurationUpdates(Consumer<ResultConfigurationUpdates.Builder> resultConfigurationUpdates) {
            return this.resultConfigurationUpdates((ResultConfigurationUpdates)((ResultConfigurationUpdates.Builder)ResultConfigurationUpdates.builder().applyMutation(resultConfigurationUpdates)).build());
        }

        public Builder publishCloudWatchMetricsEnabled(Boolean var1);

        public Builder bytesScannedCutoffPerQuery(Long var1);

        public Builder removeBytesScannedCutoffPerQuery(Boolean var1);
    }
}

