/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3LoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3LoggingConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(S3LoggingConfiguration.getter(S3LoggingConfiguration::enabled)).setter(S3LoggingConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(S3LoggingConfiguration.getter(S3LoggingConfiguration::kmsKey)).setter(S3LoggingConfiguration.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<String> LOG_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLocation").getter(S3LoggingConfiguration.getter(S3LoggingConfiguration::logLocation)).setter(S3LoggingConfiguration.setter(Builder::logLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, KMS_KEY_FIELD, LOG_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3LoggingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String kmsKey;
    private final String logLocation;

    private S3LoggingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.kmsKey = builder.kmsKey;
        this.logLocation = builder.logLocation;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String logLocation() {
        return this.logLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LoggingConfiguration)) {
            return false;
        }
        S3LoggingConfiguration other = (S3LoggingConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.logLocation(), other.logLocation());
    }

    public final String toString() {
        return ToString.builder((String)"S3LoggingConfiguration").add("Enabled", (Object)this.enabled()).add("KmsKey", (Object)this.kmsKey()).add("LogLocation", (Object)this.logLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "LogLocation": {
                return Optional.ofNullable(clazz.cast(this.logLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("LogLocation", LOG_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3LoggingConfiguration, T> g) {
        return obj -> g.apply((S3LoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String kmsKey;
        private String logLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LoggingConfiguration model) {
            this.enabled(model.enabled);
            this.kmsKey(model.kmsKey);
            this.logLocation(model.logLocation);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getLogLocation() {
            return this.logLocation;
        }

        public final void setLogLocation(String logLocation) {
            this.logLocation = logLocation;
        }

        @Override
        public final Builder logLocation(String logLocation) {
            this.logLocation = logLocation;
            return this;
        }

        public S3LoggingConfiguration build() {
            return new S3LoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3LoggingConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder logLocation(String var1);
    }
}

