/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.CalculationResult;
import software.amazon.awssdk.services.athena.model.CalculationStatistics;
import software.amazon.awssdk.services.athena.model.CalculationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCalculationExecutionResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, GetCalculationExecutionResponse> {
    private static final SdkField<String> CALCULATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculationExecutionId").getter(GetCalculationExecutionResponse.getter(GetCalculationExecutionResponse::calculationExecutionId)).setter(GetCalculationExecutionResponse.setter(Builder::calculationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculationExecutionId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(GetCalculationExecutionResponse.getter(GetCalculationExecutionResponse::sessionId)).setter(GetCalculationExecutionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetCalculationExecutionResponse.getter(GetCalculationExecutionResponse::description)).setter(GetCalculationExecutionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(GetCalculationExecutionResponse.getter(GetCalculationExecutionResponse::workingDirectory)).setter(GetCalculationExecutionResponse.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final SdkField<CalculationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(GetCalculationExecutionResponse.getter(GetCalculationExecutionResponse::status)).setter(GetCalculationExecutionResponse.setter(Builder::status)).constructor(CalculationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CalculationStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(GetCalculationExecutionResponse.getter(GetCalculationExecutionResponse::statistics)).setter(GetCalculationExecutionResponse.setter(Builder::statistics)).constructor(CalculationStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final SdkField<CalculationResult> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Result").getter(GetCalculationExecutionResponse.getter(GetCalculationExecutionResponse::result)).setter(GetCalculationExecutionResponse.setter(Builder::result)).constructor(CalculationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATION_EXECUTION_ID_FIELD, SESSION_ID_FIELD, DESCRIPTION_FIELD, WORKING_DIRECTORY_FIELD, STATUS_FIELD, STATISTICS_FIELD, RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCalculationExecutionResponse.memberNameToFieldInitializer();
    private final String calculationExecutionId;
    private final String sessionId;
    private final String description;
    private final String workingDirectory;
    private final CalculationStatus status;
    private final CalculationStatistics statistics;
    private final CalculationResult result;

    private GetCalculationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.calculationExecutionId = builder.calculationExecutionId;
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.workingDirectory = builder.workingDirectory;
        this.status = builder.status;
        this.statistics = builder.statistics;
        this.result = builder.result;
    }

    public final String calculationExecutionId() {
        return this.calculationExecutionId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String description() {
        return this.description;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final CalculationStatus status() {
        return this.status;
    }

    public final CalculationStatistics statistics() {
        return this.statistics;
    }

    public final CalculationResult result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalculationExecutionResponse)) {
            return false;
        }
        GetCalculationExecutionResponse other = (GetCalculationExecutionResponse)((Object)obj);
        return Objects.equals(this.calculationExecutionId(), other.calculationExecutionId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.result(), other.result());
    }

    public final String toString() {
        return ToString.builder((String)"GetCalculationExecutionResponse").add("CalculationExecutionId", (Object)this.calculationExecutionId()).add("SessionId", (Object)this.sessionId()).add("Description", (Object)this.description()).add("WorkingDirectory", (Object)this.workingDirectory()).add("Status", (Object)this.status()).add("Statistics", (Object)this.statistics()).add("Result", (Object)this.result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.calculationExecutionId()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CalculationExecutionId", CALCULATION_EXECUTION_ID_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("WorkingDirectory", WORKING_DIRECTORY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        map.put("Result", RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCalculationExecutionResponse, T> g) {
        return obj -> g.apply((GetCalculationExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String calculationExecutionId;
        private String sessionId;
        private String description;
        private String workingDirectory;
        private CalculationStatus status;
        private CalculationStatistics statistics;
        private CalculationResult result;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalculationExecutionResponse model) {
            super(model);
            this.calculationExecutionId(model.calculationExecutionId);
            this.sessionId(model.sessionId);
            this.description(model.description);
            this.workingDirectory(model.workingDirectory);
            this.status(model.status);
            this.statistics(model.statistics);
            this.result(model.result);
        }

        public final String getCalculationExecutionId() {
            return this.calculationExecutionId;
        }

        public final void setCalculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
        }

        @Override
        public final Builder calculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final CalculationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(CalculationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CalculationStatus status) {
            this.status = status;
            return this;
        }

        public final CalculationStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(CalculationStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(CalculationStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final CalculationResult.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        public final void setResult(CalculationResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(CalculationResult result) {
            this.result = result;
            return this;
        }

        @Override
        public GetCalculationExecutionResponse build() {
            return new GetCalculationExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCalculationExecutionResponse> {
        public Builder calculationExecutionId(String var1);

        public Builder sessionId(String var1);

        public Builder description(String var1);

        public Builder workingDirectory(String var1);

        public Builder status(CalculationStatus var1);

        default public Builder status(Consumer<CalculationStatus.Builder> status) {
            return this.status((CalculationStatus)((CalculationStatus.Builder)CalculationStatus.builder().applyMutation(status)).build());
        }

        public Builder statistics(CalculationStatistics var1);

        default public Builder statistics(Consumer<CalculationStatistics.Builder> statistics) {
            return this.statistics((CalculationStatistics)((CalculationStatistics.Builder)CalculationStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder result(CalculationResult var1);

        default public Builder result(Consumer<CalculationResult.Builder> result) {
            return this.result((CalculationResult)((CalculationResult.Builder)CalculationResult.builder().applyMutation(result)).build());
        }
    }
}

