/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionResponse extends AthenaResponse implements
        ToCopyableBuilder<GetSessionResponse.Builder, GetSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(GetSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetSessionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(GetSessionResponse::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(GetSessionResponse::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<EngineConfiguration> ENGINE_CONFIGURATION_FIELD = SdkField
            .<EngineConfiguration> builder(MarshallingType.SDK_POJO).memberName("EngineConfiguration")
            .getter(getter(GetSessionResponse::engineConfiguration)).setter(setter(Builder::engineConfiguration))
            .constructor(EngineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineConfiguration").build())
            .build();

    private static final SdkField<String> NOTEBOOK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookVersion").getter(getter(GetSessionResponse::notebookVersion))
            .setter(setter(Builder::notebookVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookVersion").build()).build();

    private static final SdkField<SessionConfiguration> SESSION_CONFIGURATION_FIELD = SdkField
            .<SessionConfiguration> builder(MarshallingType.SDK_POJO).memberName("SessionConfiguration")
            .getter(getter(GetSessionResponse::sessionConfiguration)).setter(setter(Builder::sessionConfiguration))
            .constructor(SessionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionConfiguration").build())
            .build();

    private static final SdkField<SessionStatus> STATUS_FIELD = SdkField.<SessionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(GetSessionResponse::status)).setter(setter(Builder::status))
            .constructor(SessionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<SessionStatistics> STATISTICS_FIELD = SdkField
            .<SessionStatistics> builder(MarshallingType.SDK_POJO).memberName("Statistics")
            .getter(getter(GetSessionResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(SessionStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            DESCRIPTION_FIELD, WORK_GROUP_FIELD, ENGINE_VERSION_FIELD, ENGINE_CONFIGURATION_FIELD, NOTEBOOK_VERSION_FIELD,
            SESSION_CONFIGURATION_FIELD, STATUS_FIELD, STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String description;

    private final String workGroup;

    private final String engineVersion;

    private final EngineConfiguration engineConfiguration;

    private final String notebookVersion;

    private final SessionConfiguration sessionConfiguration;

    private final SessionStatus status;

    private final SessionStatistics statistics;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.workGroup = builder.workGroup;
        this.engineVersion = builder.engineVersion;
        this.engineConfiguration = builder.engineConfiguration;
        this.notebookVersion = builder.notebookVersion;
        this.sessionConfiguration = builder.sessionConfiguration;
        this.status = builder.status;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The session description.
     * </p>
     * 
     * @return The session description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The workgroup to which the session belongs.
     * </p>
     * 
     * @return The workgroup to which the session belongs.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The engine version used by the session (for example, <code>PySpark engine version 3</code>). You can get a list
     * of engine versions by calling <a>ListEngineVersions</a>.
     * </p>
     * 
     * @return The engine version used by the session (for example, <code>PySpark engine version 3</code>). You can get
     *         a list of engine versions by calling <a>ListEngineVersions</a>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Contains engine configuration information like DPU usage.
     * </p>
     * 
     * @return Contains engine configuration information like DPU usage.
     */
    public final EngineConfiguration engineConfiguration() {
        return engineConfiguration;
    }

    /**
     * <p>
     * The notebook version.
     * </p>
     * 
     * @return The notebook version.
     */
    public final String notebookVersion() {
        return notebookVersion;
    }

    /**
     * <p>
     * Contains the workgroup configuration information used by the session.
     * </p>
     * 
     * @return Contains the workgroup configuration information used by the session.
     */
    public final SessionConfiguration sessionConfiguration() {
        return sessionConfiguration;
    }

    /**
     * <p>
     * Contains information about the status of the session.
     * </p>
     * 
     * @return Contains information about the status of the session.
     */
    public final SessionStatus status() {
        return status;
    }

    /**
     * <p>
     * Contains the DPU execution time.
     * </p>
     * 
     * @return Contains the DPU execution time.
     */
    public final SessionStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notebookVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sessionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(description(), other.description())
                && Objects.equals(workGroup(), other.workGroup()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(engineConfiguration(), other.engineConfiguration())
                && Objects.equals(notebookVersion(), other.notebookVersion())
                && Objects.equals(sessionConfiguration(), other.sessionConfiguration())
                && Objects.equals(status(), other.status()) && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionResponse").add("SessionId", sessionId()).add("Description", description())
                .add("WorkGroup", workGroup()).add("EngineVersion", engineVersion())
                .add("EngineConfiguration", engineConfiguration()).add("NotebookVersion", notebookVersion())
                .add("SessionConfiguration", sessionConfiguration()).add("Status", status()).add("Statistics", statistics())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EngineConfiguration":
            return Optional.ofNullable(clazz.cast(engineConfiguration()));
        case "NotebookVersion":
            return Optional.ofNullable(clazz.cast(notebookVersion()));
        case "SessionConfiguration":
            return Optional.ofNullable(clazz.cast(sessionConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("EngineConfiguration", ENGINE_CONFIGURATION_FIELD);
        map.put("NotebookVersion", NOTEBOOK_VERSION_FIELD);
        map.put("SessionConfiguration", SESSION_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionResponse> {
        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The session description.
         * </p>
         * 
         * @param description
         *        The session description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The workgroup to which the session belongs.
         * </p>
         * 
         * @param workGroup
         *        The workgroup to which the session belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The engine version used by the session (for example, <code>PySpark engine version 3</code>). You can get a
         * list of engine versions by calling <a>ListEngineVersions</a>.
         * </p>
         * 
         * @param engineVersion
         *        The engine version used by the session (for example, <code>PySpark engine version 3</code>). You can
         *        get a list of engine versions by calling <a>ListEngineVersions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Contains engine configuration information like DPU usage.
         * </p>
         * 
         * @param engineConfiguration
         *        Contains engine configuration information like DPU usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineConfiguration(EngineConfiguration engineConfiguration);

        /**
         * <p>
         * Contains engine configuration information like DPU usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngineConfiguration.Builder} avoiding the
         * need to create one manually via {@link EngineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #engineConfiguration(EngineConfiguration)}.
         * 
         * @param engineConfiguration
         *        a consumer that will call methods on {@link EngineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineConfiguration(EngineConfiguration)
         */
        default Builder engineConfiguration(Consumer<EngineConfiguration.Builder> engineConfiguration) {
            return engineConfiguration(EngineConfiguration.builder().applyMutation(engineConfiguration).build());
        }

        /**
         * <p>
         * The notebook version.
         * </p>
         * 
         * @param notebookVersion
         *        The notebook version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookVersion(String notebookVersion);

        /**
         * <p>
         * Contains the workgroup configuration information used by the session.
         * </p>
         * 
         * @param sessionConfiguration
         *        Contains the workgroup configuration information used by the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionConfiguration(SessionConfiguration sessionConfiguration);

        /**
         * <p>
         * Contains the workgroup configuration information used by the session.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionConfiguration.Builder} avoiding
         * the need to create one manually via {@link SessionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sessionConfiguration(SessionConfiguration)}.
         * 
         * @param sessionConfiguration
         *        a consumer that will call methods on {@link SessionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionConfiguration(SessionConfiguration)
         */
        default Builder sessionConfiguration(Consumer<SessionConfiguration.Builder> sessionConfiguration) {
            return sessionConfiguration(SessionConfiguration.builder().applyMutation(sessionConfiguration).build());
        }

        /**
         * <p>
         * Contains information about the status of the session.
         * </p>
         * 
         * @param status
         *        Contains information about the status of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * Contains information about the status of the session.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionStatus.Builder} avoiding the need
         * to create one manually via {@link SessionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SessionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SessionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SessionStatus)
         */
        default Builder status(Consumer<SessionStatus.Builder> status) {
            return status(SessionStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Contains the DPU execution time.
         * </p>
         * 
         * @param statistics
         *        Contains the DPU execution time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(SessionStatistics statistics);

        /**
         * <p>
         * Contains the DPU execution time.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionStatistics.Builder} avoiding the
         * need to create one manually via {@link SessionStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #statistics(SessionStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link SessionStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(SessionStatistics)
         */
        default Builder statistics(Consumer<SessionStatistics.Builder> statistics) {
            return statistics(SessionStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String description;

        private String workGroup;

        private String engineVersion;

        private EngineConfiguration engineConfiguration;

        private String notebookVersion;

        private SessionConfiguration sessionConfiguration;

        private SessionStatus status;

        private SessionStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            sessionId(model.sessionId);
            description(model.description);
            workGroup(model.workGroup);
            engineVersion(model.engineVersion);
            engineConfiguration(model.engineConfiguration);
            notebookVersion(model.notebookVersion);
            sessionConfiguration(model.sessionConfiguration);
            status(model.status);
            statistics(model.statistics);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final EngineConfiguration.Builder getEngineConfiguration() {
            return engineConfiguration != null ? engineConfiguration.toBuilder() : null;
        }

        public final void setEngineConfiguration(EngineConfiguration.BuilderImpl engineConfiguration) {
            this.engineConfiguration = engineConfiguration != null ? engineConfiguration.build() : null;
        }

        @Override
        public final Builder engineConfiguration(EngineConfiguration engineConfiguration) {
            this.engineConfiguration = engineConfiguration;
            return this;
        }

        public final String getNotebookVersion() {
            return notebookVersion;
        }

        public final void setNotebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
        }

        @Override
        public final Builder notebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
            return this;
        }

        public final SessionConfiguration.Builder getSessionConfiguration() {
            return sessionConfiguration != null ? sessionConfiguration.toBuilder() : null;
        }

        public final void setSessionConfiguration(SessionConfiguration.BuilderImpl sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration != null ? sessionConfiguration.build() : null;
        }

        @Override
        public final Builder sessionConfiguration(SessionConfiguration sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration;
            return this;
        }

        public final SessionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SessionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status = status;
            return this;
        }

        public final SessionStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(SessionStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(SessionStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
