/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDataCatalogRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, DeleteDataCatalogRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DeleteDataCatalogRequest.getter(DeleteDataCatalogRequest::name)).setter(DeleteDataCatalogRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> DELETE_CATALOG_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteCatalogOnly").getter(DeleteDataCatalogRequest.getter(DeleteDataCatalogRequest::deleteCatalogOnly)).setter(DeleteDataCatalogRequest.setter(Builder::deleteCatalogOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteCatalogOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DELETE_CATALOG_ONLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteDataCatalogRequest.memberNameToFieldInitializer();
    private final String name;
    private final Boolean deleteCatalogOnly;

    private DeleteDataCatalogRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.deleteCatalogOnly = builder.deleteCatalogOnly;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean deleteCatalogOnly() {
        return this.deleteCatalogOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteCatalogOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataCatalogRequest)) {
            return false;
        }
        DeleteDataCatalogRequest other = (DeleteDataCatalogRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.deleteCatalogOnly(), other.deleteCatalogOnly());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDataCatalogRequest").add("Name", (Object)this.name()).add("DeleteCatalogOnly", (Object)this.deleteCatalogOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DeleteCatalogOnly": {
                return Optional.ofNullable(clazz.cast(this.deleteCatalogOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("DeleteCatalogOnly", DELETE_CATALOG_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataCatalogRequest, T> g) {
        return obj -> g.apply((DeleteDataCatalogRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String name;
        private Boolean deleteCatalogOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataCatalogRequest model) {
            super(model);
            this.name(model.name);
            this.deleteCatalogOnly(model.deleteCatalogOnly);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDeleteCatalogOnly() {
            return this.deleteCatalogOnly;
        }

        public final void setDeleteCatalogOnly(Boolean deleteCatalogOnly) {
            this.deleteCatalogOnly = deleteCatalogOnly;
        }

        @Override
        public final Builder deleteCatalogOnly(Boolean deleteCatalogOnly) {
            this.deleteCatalogOnly = deleteCatalogOnly;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataCatalogRequest build() {
            return new DeleteDataCatalogRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDataCatalogRequest> {
        public Builder name(String var1);

        public Builder deleteCatalogOnly(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

