/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.NamedQuery;
import software.amazon.awssdk.services.athena.model.NamedQueryListCopier;
import software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId;
import software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetNamedQueryResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, BatchGetNamedQueryResponse> {
    private static final SdkField<List<NamedQuery>> NAMED_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NamedQueries").getter(BatchGetNamedQueryResponse.getter(BatchGetNamedQueryResponse::namedQueries)).setter(BatchGetNamedQueryResponse.setter(Builder::namedQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NamedQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedNamedQueryId>> UNPROCESSED_NAMED_QUERY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedNamedQueryIds").getter(BatchGetNamedQueryResponse.getter(BatchGetNamedQueryResponse::unprocessedNamedQueryIds)).setter(BatchGetNamedQueryResponse.setter(Builder::unprocessedNamedQueryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedNamedQueryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedNamedQueryId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERIES_FIELD, UNPROCESSED_NAMED_QUERY_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetNamedQueryResponse.memberNameToFieldInitializer();
    private final List<NamedQuery> namedQueries;
    private final List<UnprocessedNamedQueryId> unprocessedNamedQueryIds;

    private BatchGetNamedQueryResponse(BuilderImpl builder) {
        super(builder);
        this.namedQueries = builder.namedQueries;
        this.unprocessedNamedQueryIds = builder.unprocessedNamedQueryIds;
    }

    public final boolean hasNamedQueries() {
        return this.namedQueries != null && !(this.namedQueries instanceof SdkAutoConstructList);
    }

    public final List<NamedQuery> namedQueries() {
        return this.namedQueries;
    }

    public final boolean hasUnprocessedNamedQueryIds() {
        return this.unprocessedNamedQueryIds != null && !(this.unprocessedNamedQueryIds instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedNamedQueryId> unprocessedNamedQueryIds() {
        return this.unprocessedNamedQueryIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamedQueries() ? this.namedQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedNamedQueryIds() ? this.unprocessedNamedQueryIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetNamedQueryResponse)) {
            return false;
        }
        BatchGetNamedQueryResponse other = (BatchGetNamedQueryResponse)((Object)obj);
        return this.hasNamedQueries() == other.hasNamedQueries() && Objects.equals(this.namedQueries(), other.namedQueries()) && this.hasUnprocessedNamedQueryIds() == other.hasUnprocessedNamedQueryIds() && Objects.equals(this.unprocessedNamedQueryIds(), other.unprocessedNamedQueryIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetNamedQueryResponse").add("NamedQueries", this.hasNamedQueries() ? this.namedQueries() : null).add("UnprocessedNamedQueryIds", this.hasUnprocessedNamedQueryIds() ? this.unprocessedNamedQueryIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueries": {
                return Optional.ofNullable(clazz.cast(this.namedQueries()));
            }
            case "UnprocessedNamedQueryIds": {
                return Optional.ofNullable(clazz.cast(this.unprocessedNamedQueryIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NamedQueries", NAMED_QUERIES_FIELD);
        map.put("UnprocessedNamedQueryIds", UNPROCESSED_NAMED_QUERY_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetNamedQueryResponse, T> g) {
        return obj -> g.apply((BatchGetNamedQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<NamedQuery> namedQueries = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedNamedQueryId> unprocessedNamedQueryIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetNamedQueryResponse model) {
            super(model);
            this.namedQueries(model.namedQueries);
            this.unprocessedNamedQueryIds(model.unprocessedNamedQueryIds);
        }

        public final List<NamedQuery.Builder> getNamedQueries() {
            List<NamedQuery.Builder> result = NamedQueryListCopier.copyToBuilder(this.namedQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNamedQueries(Collection<NamedQuery.BuilderImpl> namedQueries) {
            this.namedQueries = NamedQueryListCopier.copyFromBuilder(namedQueries);
        }

        @Override
        public final Builder namedQueries(Collection<NamedQuery> namedQueries) {
            this.namedQueries = NamedQueryListCopier.copy(namedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueries(NamedQuery ... namedQueries) {
            this.namedQueries(Arrays.asList(namedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueries(Consumer<NamedQuery.Builder> ... namedQueries) {
            this.namedQueries(Stream.of(namedQueries).map(c -> (NamedQuery)((NamedQuery.Builder)NamedQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedNamedQueryId.Builder> getUnprocessedNamedQueryIds() {
            List<UnprocessedNamedQueryId.Builder> result = UnprocessedNamedQueryIdListCopier.copyToBuilder(this.unprocessedNamedQueryIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId.BuilderImpl> unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds = UnprocessedNamedQueryIdListCopier.copyFromBuilder(unprocessedNamedQueryIds);
        }

        @Override
        public final Builder unprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId> unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds = UnprocessedNamedQueryIdListCopier.copy(unprocessedNamedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedNamedQueryIds(UnprocessedNamedQueryId ... unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds(Arrays.asList(unprocessedNamedQueryIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedNamedQueryIds(Consumer<UnprocessedNamedQueryId.Builder> ... unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds(Stream.of(unprocessedNamedQueryIds).map(c -> (UnprocessedNamedQueryId)((UnprocessedNamedQueryId.Builder)UnprocessedNamedQueryId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetNamedQueryResponse build() {
            return new BatchGetNamedQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetNamedQueryResponse> {
        public Builder namedQueries(Collection<NamedQuery> var1);

        public Builder namedQueries(NamedQuery ... var1);

        public Builder namedQueries(Consumer<NamedQuery.Builder> ... var1);

        public Builder unprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId> var1);

        public Builder unprocessedNamedQueryIds(UnprocessedNamedQueryId ... var1);

        public Builder unprocessedNamedQueryIds(Consumer<UnprocessedNamedQueryId.Builder> ... var1);
    }
}

