/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AclConfiguration;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultConfigurationUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultConfigurationUpdates> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocation").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::outputLocation)).setter(ResultConfigurationUpdates.setter(Builder::outputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<Boolean> REMOVE_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveOutputLocation").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::removeOutputLocation)).setter(ResultConfigurationUpdates.setter(Builder::removeOutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOutputLocation").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::encryptionConfiguration)).setter(ResultConfigurationUpdates.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<Boolean> REMOVE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveEncryptionConfiguration").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::removeEncryptionConfiguration)).setter(ResultConfigurationUpdates.setter(Builder::removeEncryptionConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEncryptionConfiguration").build()}).build();
    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedBucketOwner").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::expectedBucketOwner)).setter(ResultConfigurationUpdates.setter(Builder::expectedBucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedBucketOwner").build()}).build();
    private static final SdkField<Boolean> REMOVE_EXPECTED_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveExpectedBucketOwner").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::removeExpectedBucketOwner)).setter(ResultConfigurationUpdates.setter(Builder::removeExpectedBucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveExpectedBucketOwner").build()}).build();
    private static final SdkField<AclConfiguration> ACL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AclConfiguration").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::aclConfiguration)).setter(ResultConfigurationUpdates.setter(Builder::aclConfiguration)).constructor(AclConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclConfiguration").build()}).build();
    private static final SdkField<Boolean> REMOVE_ACL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveAclConfiguration").getter(ResultConfigurationUpdates.getter(ResultConfigurationUpdates::removeAclConfiguration)).setter(ResultConfigurationUpdates.setter(Builder::removeAclConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAclConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD, REMOVE_OUTPUT_LOCATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, REMOVE_ENCRYPTION_CONFIGURATION_FIELD, EXPECTED_BUCKET_OWNER_FIELD, REMOVE_EXPECTED_BUCKET_OWNER_FIELD, ACL_CONFIGURATION_FIELD, REMOVE_ACL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResultConfigurationUpdates.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputLocation;
    private final Boolean removeOutputLocation;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Boolean removeEncryptionConfiguration;
    private final String expectedBucketOwner;
    private final Boolean removeExpectedBucketOwner;
    private final AclConfiguration aclConfiguration;
    private final Boolean removeAclConfiguration;

    private ResultConfigurationUpdates(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.removeOutputLocation = builder.removeOutputLocation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.removeEncryptionConfiguration = builder.removeEncryptionConfiguration;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.removeExpectedBucketOwner = builder.removeExpectedBucketOwner;
        this.aclConfiguration = builder.aclConfiguration;
        this.removeAclConfiguration = builder.removeAclConfiguration;
    }

    public final String outputLocation() {
        return this.outputLocation;
    }

    public final Boolean removeOutputLocation() {
        return this.removeOutputLocation;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final Boolean removeEncryptionConfiguration() {
        return this.removeEncryptionConfiguration;
    }

    public final String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public final Boolean removeExpectedBucketOwner() {
        return this.removeExpectedBucketOwner;
    }

    public final AclConfiguration aclConfiguration() {
        return this.aclConfiguration;
    }

    public final Boolean removeAclConfiguration() {
        return this.removeAclConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeExpectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeAclConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfigurationUpdates)) {
            return false;
        }
        ResultConfigurationUpdates other = (ResultConfigurationUpdates)obj;
        return Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.removeOutputLocation(), other.removeOutputLocation()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.removeEncryptionConfiguration(), other.removeEncryptionConfiguration()) && Objects.equals(this.expectedBucketOwner(), other.expectedBucketOwner()) && Objects.equals(this.removeExpectedBucketOwner(), other.removeExpectedBucketOwner()) && Objects.equals(this.aclConfiguration(), other.aclConfiguration()) && Objects.equals(this.removeAclConfiguration(), other.removeAclConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ResultConfigurationUpdates").add("OutputLocation", (Object)this.outputLocation()).add("RemoveOutputLocation", (Object)this.removeOutputLocation()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("RemoveEncryptionConfiguration", (Object)this.removeEncryptionConfiguration()).add("ExpectedBucketOwner", (Object)this.expectedBucketOwner()).add("RemoveExpectedBucketOwner", (Object)this.removeExpectedBucketOwner()).add("AclConfiguration", (Object)this.aclConfiguration()).add("RemoveAclConfiguration", (Object)this.removeAclConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "RemoveOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.removeOutputLocation()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "RemoveEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.removeEncryptionConfiguration()));
            }
            case "ExpectedBucketOwner": {
                return Optional.ofNullable(clazz.cast(this.expectedBucketOwner()));
            }
            case "RemoveExpectedBucketOwner": {
                return Optional.ofNullable(clazz.cast(this.removeExpectedBucketOwner()));
            }
            case "AclConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aclConfiguration()));
            }
            case "RemoveAclConfiguration": {
                return Optional.ofNullable(clazz.cast(this.removeAclConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutputLocation", OUTPUT_LOCATION_FIELD);
        map.put("RemoveOutputLocation", REMOVE_OUTPUT_LOCATION_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("RemoveEncryptionConfiguration", REMOVE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("ExpectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        map.put("RemoveExpectedBucketOwner", REMOVE_EXPECTED_BUCKET_OWNER_FIELD);
        map.put("AclConfiguration", ACL_CONFIGURATION_FIELD);
        map.put("RemoveAclConfiguration", REMOVE_ACL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultConfigurationUpdates, T> g) {
        return obj -> g.apply((ResultConfigurationUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputLocation;
        private Boolean removeOutputLocation;
        private EncryptionConfiguration encryptionConfiguration;
        private Boolean removeEncryptionConfiguration;
        private String expectedBucketOwner;
        private Boolean removeExpectedBucketOwner;
        private AclConfiguration aclConfiguration;
        private Boolean removeAclConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultConfigurationUpdates model) {
            this.outputLocation(model.outputLocation);
            this.removeOutputLocation(model.removeOutputLocation);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.removeEncryptionConfiguration(model.removeEncryptionConfiguration);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.removeExpectedBucketOwner(model.removeExpectedBucketOwner);
            this.aclConfiguration(model.aclConfiguration);
            this.removeAclConfiguration(model.removeAclConfiguration);
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final Boolean getRemoveOutputLocation() {
            return this.removeOutputLocation;
        }

        public final void setRemoveOutputLocation(Boolean removeOutputLocation) {
            this.removeOutputLocation = removeOutputLocation;
        }

        @Override
        public final Builder removeOutputLocation(Boolean removeOutputLocation) {
            this.removeOutputLocation = removeOutputLocation;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Boolean getRemoveEncryptionConfiguration() {
            return this.removeEncryptionConfiguration;
        }

        public final void setRemoveEncryptionConfiguration(Boolean removeEncryptionConfiguration) {
            this.removeEncryptionConfiguration = removeEncryptionConfiguration;
        }

        @Override
        public final Builder removeEncryptionConfiguration(Boolean removeEncryptionConfiguration) {
            this.removeEncryptionConfiguration = removeEncryptionConfiguration;
            return this;
        }

        public final String getExpectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final Boolean getRemoveExpectedBucketOwner() {
            return this.removeExpectedBucketOwner;
        }

        public final void setRemoveExpectedBucketOwner(Boolean removeExpectedBucketOwner) {
            this.removeExpectedBucketOwner = removeExpectedBucketOwner;
        }

        @Override
        public final Builder removeExpectedBucketOwner(Boolean removeExpectedBucketOwner) {
            this.removeExpectedBucketOwner = removeExpectedBucketOwner;
            return this;
        }

        public final AclConfiguration.Builder getAclConfiguration() {
            return this.aclConfiguration != null ? this.aclConfiguration.toBuilder() : null;
        }

        public final void setAclConfiguration(AclConfiguration.BuilderImpl aclConfiguration) {
            this.aclConfiguration = aclConfiguration != null ? aclConfiguration.build() : null;
        }

        @Override
        public final Builder aclConfiguration(AclConfiguration aclConfiguration) {
            this.aclConfiguration = aclConfiguration;
            return this;
        }

        public final Boolean getRemoveAclConfiguration() {
            return this.removeAclConfiguration;
        }

        public final void setRemoveAclConfiguration(Boolean removeAclConfiguration) {
            this.removeAclConfiguration = removeAclConfiguration;
        }

        @Override
        public final Builder removeAclConfiguration(Boolean removeAclConfiguration) {
            this.removeAclConfiguration = removeAclConfiguration;
            return this;
        }

        public ResultConfigurationUpdates build() {
            return new ResultConfigurationUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultConfigurationUpdates> {
        public Builder outputLocation(String var1);

        public Builder removeOutputLocation(Boolean var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder removeEncryptionConfiguration(Boolean var1);

        public Builder expectedBucketOwner(String var1);

        public Builder removeExpectedBucketOwner(Boolean var1);

        public Builder aclConfiguration(AclConfiguration var1);

        default public Builder aclConfiguration(Consumer<AclConfiguration.Builder> aclConfiguration) {
            return this.aclConfiguration((AclConfiguration)((AclConfiguration.Builder)AclConfiguration.builder().applyMutation(aclConfiguration)).build());
        }

        public Builder removeAclConfiguration(Boolean var1);
    }
}

