/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.QueryStagePlanNode;
import software.amazon.awssdk.services.athena.model.QueryStagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryStage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryStage> {
    private static final SdkField<Long> STAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StageId").getter(QueryStage.getter(QueryStage::stageId)).setter(QueryStage.setter(Builder::stageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(QueryStage.getter(QueryStage::state)).setter(QueryStage.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Long> OUTPUT_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OutputBytes").getter(QueryStage.getter(QueryStage::outputBytes)).setter(QueryStage.setter(Builder::outputBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBytes").build()}).build();
    private static final SdkField<Long> OUTPUT_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OutputRows").getter(QueryStage.getter(QueryStage::outputRows)).setter(QueryStage.setter(Builder::outputRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputRows").build()}).build();
    private static final SdkField<Long> INPUT_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InputBytes").getter(QueryStage.getter(QueryStage::inputBytes)).setter(QueryStage.setter(Builder::inputBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBytes").build()}).build();
    private static final SdkField<Long> INPUT_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InputRows").getter(QueryStage.getter(QueryStage::inputRows)).setter(QueryStage.setter(Builder::inputRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputRows").build()}).build();
    private static final SdkField<Long> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ExecutionTime").getter(QueryStage.getter(QueryStage::executionTime)).setter(QueryStage.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final SdkField<QueryStagePlanNode> QUERY_STAGE_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStagePlan").getter(QueryStage.getter(QueryStage::queryStagePlan)).setter(QueryStage.setter(Builder::queryStagePlan)).constructor(QueryStagePlanNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStagePlan").build()}).build();
    private static final SdkField<List<QueryStage>> SUB_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubStages").getter(QueryStage.getter(QueryStage::subStages)).setter(QueryStage.setter(Builder::subStages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubStages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryStage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ID_FIELD, STATE_FIELD, OUTPUT_BYTES_FIELD, OUTPUT_ROWS_FIELD, INPUT_BYTES_FIELD, INPUT_ROWS_FIELD, EXECUTION_TIME_FIELD, QUERY_STAGE_PLAN_FIELD, SUB_STAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryStage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long stageId;
    private final String state;
    private final Long outputBytes;
    private final Long outputRows;
    private final Long inputBytes;
    private final Long inputRows;
    private final Long executionTime;
    private final QueryStagePlanNode queryStagePlan;
    private final List<QueryStage> subStages;

    private QueryStage(BuilderImpl builder) {
        this.stageId = builder.stageId;
        this.state = builder.state;
        this.outputBytes = builder.outputBytes;
        this.outputRows = builder.outputRows;
        this.inputBytes = builder.inputBytes;
        this.inputRows = builder.inputRows;
        this.executionTime = builder.executionTime;
        this.queryStagePlan = builder.queryStagePlan;
        this.subStages = builder.subStages;
    }

    public final Long stageId() {
        return this.stageId;
    }

    public final String state() {
        return this.state;
    }

    public final Long outputBytes() {
        return this.outputBytes;
    }

    public final Long outputRows() {
        return this.outputRows;
    }

    public final Long inputBytes() {
        return this.inputBytes;
    }

    public final Long inputRows() {
        return this.inputRows;
    }

    public final Long executionTime() {
        return this.executionTime;
    }

    public final QueryStagePlanNode queryStagePlan() {
        return this.queryStagePlan;
    }

    public final boolean hasSubStages() {
        return this.subStages != null && !(this.subStages instanceof SdkAutoConstructList);
    }

    public final List<QueryStage> subStages() {
        return this.subStages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStagePlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubStages() ? this.subStages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStage)) {
            return false;
        }
        QueryStage other = (QueryStage)obj;
        return Objects.equals(this.stageId(), other.stageId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.outputBytes(), other.outputBytes()) && Objects.equals(this.outputRows(), other.outputRows()) && Objects.equals(this.inputBytes(), other.inputBytes()) && Objects.equals(this.inputRows(), other.inputRows()) && Objects.equals(this.executionTime(), other.executionTime()) && Objects.equals(this.queryStagePlan(), other.queryStagePlan()) && this.hasSubStages() == other.hasSubStages() && Objects.equals(this.subStages(), other.subStages());
    }

    public final String toString() {
        return ToString.builder((String)"QueryStage").add("StageId", (Object)this.stageId()).add("State", (Object)this.state()).add("OutputBytes", (Object)this.outputBytes()).add("OutputRows", (Object)this.outputRows()).add("InputBytes", (Object)this.inputBytes()).add("InputRows", (Object)this.inputRows()).add("ExecutionTime", (Object)this.executionTime()).add("QueryStagePlan", (Object)this.queryStagePlan()).add("SubStages", this.hasSubStages() ? this.subStages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StageId": {
                return Optional.ofNullable(clazz.cast(this.stageId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "OutputBytes": {
                return Optional.ofNullable(clazz.cast(this.outputBytes()));
            }
            case "OutputRows": {
                return Optional.ofNullable(clazz.cast(this.outputRows()));
            }
            case "InputBytes": {
                return Optional.ofNullable(clazz.cast(this.inputBytes()));
            }
            case "InputRows": {
                return Optional.ofNullable(clazz.cast(this.inputRows()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
            case "QueryStagePlan": {
                return Optional.ofNullable(clazz.cast(this.queryStagePlan()));
            }
            case "SubStages": {
                return Optional.ofNullable(clazz.cast(this.subStages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StageId", STAGE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("OutputBytes", OUTPUT_BYTES_FIELD);
        map.put("OutputRows", OUTPUT_ROWS_FIELD);
        map.put("InputBytes", INPUT_BYTES_FIELD);
        map.put("InputRows", INPUT_ROWS_FIELD);
        map.put("ExecutionTime", EXECUTION_TIME_FIELD);
        map.put("QueryStagePlan", QUERY_STAGE_PLAN_FIELD);
        map.put("SubStages", SUB_STAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStage, T> g) {
        return obj -> g.apply((QueryStage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long stageId;
        private String state;
        private Long outputBytes;
        private Long outputRows;
        private Long inputBytes;
        private Long inputRows;
        private Long executionTime;
        private QueryStagePlanNode queryStagePlan;
        private List<QueryStage> subStages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStage model) {
            this.stageId(model.stageId);
            this.state(model.state);
            this.outputBytes(model.outputBytes);
            this.outputRows(model.outputRows);
            this.inputBytes(model.inputBytes);
            this.inputRows(model.inputRows);
            this.executionTime(model.executionTime);
            this.queryStagePlan(model.queryStagePlan);
            this.subStages(model.subStages);
        }

        public final Long getStageId() {
            return this.stageId;
        }

        public final void setStageId(Long stageId) {
            this.stageId = stageId;
        }

        @Override
        public final Builder stageId(Long stageId) {
            this.stageId = stageId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final Long getOutputBytes() {
            return this.outputBytes;
        }

        public final void setOutputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
        }

        @Override
        public final Builder outputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
            return this;
        }

        public final Long getOutputRows() {
            return this.outputRows;
        }

        public final void setOutputRows(Long outputRows) {
            this.outputRows = outputRows;
        }

        @Override
        public final Builder outputRows(Long outputRows) {
            this.outputRows = outputRows;
            return this;
        }

        public final Long getInputBytes() {
            return this.inputBytes;
        }

        public final void setInputBytes(Long inputBytes) {
            this.inputBytes = inputBytes;
        }

        @Override
        public final Builder inputBytes(Long inputBytes) {
            this.inputBytes = inputBytes;
            return this;
        }

        public final Long getInputRows() {
            return this.inputRows;
        }

        public final void setInputRows(Long inputRows) {
            this.inputRows = inputRows;
        }

        @Override
        public final Builder inputRows(Long inputRows) {
            this.inputRows = inputRows;
            return this;
        }

        public final Long getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Long executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Long executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final QueryStagePlanNode.Builder getQueryStagePlan() {
            return this.queryStagePlan != null ? this.queryStagePlan.toBuilder() : null;
        }

        public final void setQueryStagePlan(QueryStagePlanNode.BuilderImpl queryStagePlan) {
            this.queryStagePlan = queryStagePlan != null ? queryStagePlan.build() : null;
        }

        @Override
        public final Builder queryStagePlan(QueryStagePlanNode queryStagePlan) {
            this.queryStagePlan = queryStagePlan;
            return this;
        }

        public final List<Builder> getSubStages() {
            List<Builder> result = QueryStagesCopier.copyToBuilder(this.subStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubStages(Collection<BuilderImpl> subStages) {
            this.subStages = QueryStagesCopier.copyFromBuilder(subStages);
        }

        @Override
        public final Builder subStages(Collection<QueryStage> subStages) {
            this.subStages = QueryStagesCopier.copy(subStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subStages(QueryStage ... subStages) {
            this.subStages(Arrays.asList(subStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subStages(Consumer<Builder> ... subStages) {
            this.subStages(Stream.of(subStages).map(c -> (QueryStage)((Builder)QueryStage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public QueryStage build() {
            return new QueryStage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryStage> {
        public Builder stageId(Long var1);

        public Builder state(String var1);

        public Builder outputBytes(Long var1);

        public Builder outputRows(Long var1);

        public Builder inputBytes(Long var1);

        public Builder inputRows(Long var1);

        public Builder executionTime(Long var1);

        public Builder queryStagePlan(QueryStagePlanNode var1);

        default public Builder queryStagePlan(Consumer<QueryStagePlanNode.Builder> queryStagePlan) {
            return this.queryStagePlan((QueryStagePlanNode)((QueryStagePlanNode.Builder)QueryStagePlanNode.builder().applyMutation(queryStagePlan)).build());
        }

        public Builder subStages(Collection<QueryStage> var1);

        public Builder subStages(QueryStage ... var1);

        public Builder subStages(Consumer<Builder> ... var1);
    }
}

