/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.NamedQueryIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetNamedQueryRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, BatchGetNamedQueryRequest> {
    private static final SdkField<List<String>> NAMED_QUERY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NamedQueryIds").getter(BatchGetNamedQueryRequest.getter(BatchGetNamedQueryRequest::namedQueryIds)).setter(BatchGetNamedQueryRequest.setter(Builder::namedQueryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetNamedQueryRequest.memberNameToFieldInitializer();
    private final List<String> namedQueryIds;

    private BatchGetNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.namedQueryIds = builder.namedQueryIds;
    }

    public final boolean hasNamedQueryIds() {
        return this.namedQueryIds != null && !(this.namedQueryIds instanceof SdkAutoConstructList);
    }

    public final List<String> namedQueryIds() {
        return this.namedQueryIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamedQueryIds() ? this.namedQueryIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetNamedQueryRequest)) {
            return false;
        }
        BatchGetNamedQueryRequest other = (BatchGetNamedQueryRequest)((Object)obj);
        return this.hasNamedQueryIds() == other.hasNamedQueryIds() && Objects.equals(this.namedQueryIds(), other.namedQueryIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetNamedQueryRequest").add("NamedQueryIds", this.hasNamedQueryIds() ? this.namedQueryIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueryIds": {
                return Optional.ofNullable(clazz.cast(this.namedQueryIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("NamedQueryIds", NAMED_QUERY_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetNamedQueryRequest, T> g) {
        return obj -> g.apply((BatchGetNamedQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private List<String> namedQueryIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetNamedQueryRequest model) {
            super(model);
            this.namedQueryIds(model.namedQueryIds);
        }

        public final Collection<String> getNamedQueryIds() {
            if (this.namedQueryIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namedQueryIds;
        }

        public final void setNamedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
        }

        @Override
        public final Builder namedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueryIds(String ... namedQueryIds) {
            this.namedQueryIds(Arrays.asList(namedQueryIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetNamedQueryRequest build() {
            return new BatchGetNamedQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetNamedQueryRequest> {
        public Builder namedQueryIds(Collection<String> var1);

        public Builder namedQueryIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

