/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.QueryStagePlanNodesCopier;
import software.amazon.awssdk.services.athena.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryStagePlanNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryStagePlanNode> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(QueryStagePlanNode.getter(QueryStagePlanNode::name)).setter(QueryStagePlanNode.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(QueryStagePlanNode.getter(QueryStagePlanNode::identifier)).setter(QueryStagePlanNode.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<List<QueryStagePlanNode>> CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Children").getter(QueryStagePlanNode.getter(QueryStagePlanNode::children)).setter(QueryStagePlanNode.setter(Builder::children)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryStagePlanNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOTE_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoteSources").getter(QueryStagePlanNode.getter(QueryStagePlanNode::remoteSources)).setter(QueryStagePlanNode.setter(Builder::remoteSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IDENTIFIER_FIELD, CHILDREN_FIELD, REMOTE_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Identifier", IDENTIFIER_FIELD);
            this.put("Children", CHILDREN_FIELD);
            this.put("RemoteSources", REMOTE_SOURCES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String identifier;
    private final List<QueryStagePlanNode> children;
    private final List<String> remoteSources;

    private QueryStagePlanNode(BuilderImpl builder) {
        this.name = builder.name;
        this.identifier = builder.identifier;
        this.children = builder.children;
        this.remoteSources = builder.remoteSources;
    }

    public final String name() {
        return this.name;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasChildren() {
        return this.children != null && !(this.children instanceof SdkAutoConstructList);
    }

    public final List<QueryStagePlanNode> children() {
        return this.children;
    }

    public final boolean hasRemoteSources() {
        return this.remoteSources != null && !(this.remoteSources instanceof SdkAutoConstructList);
    }

    public final List<String> remoteSources() {
        return this.remoteSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildren() ? this.children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoteSources() ? this.remoteSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStagePlanNode)) {
            return false;
        }
        QueryStagePlanNode other = (QueryStagePlanNode)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.identifier(), other.identifier()) && this.hasChildren() == other.hasChildren() && Objects.equals(this.children(), other.children()) && this.hasRemoteSources() == other.hasRemoteSources() && Objects.equals(this.remoteSources(), other.remoteSources());
    }

    public final String toString() {
        return ToString.builder((String)"QueryStagePlanNode").add("Name", (Object)this.name()).add("Identifier", (Object)this.identifier()).add("Children", this.hasChildren() ? this.children() : null).add("RemoteSources", this.hasRemoteSources() ? this.remoteSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Children": {
                return Optional.ofNullable(clazz.cast(this.children()));
            }
            case "RemoteSources": {
                return Optional.ofNullable(clazz.cast(this.remoteSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryStagePlanNode, T> g) {
        return obj -> g.apply((QueryStagePlanNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String identifier;
        private List<QueryStagePlanNode> children = DefaultSdkAutoConstructList.getInstance();
        private List<String> remoteSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStagePlanNode model) {
            this.name(model.name);
            this.identifier(model.identifier);
            this.children(model.children);
            this.remoteSources(model.remoteSources);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<Builder> getChildren() {
            List<Builder> result = QueryStagePlanNodesCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<BuilderImpl> children) {
            this.children = QueryStagePlanNodesCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<QueryStagePlanNode> children) {
            this.children = QueryStagePlanNodesCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(QueryStagePlanNode ... children) {
            this.children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<Builder> ... children) {
            this.children(Stream.of(children).map(c -> (QueryStagePlanNode)((Builder)QueryStagePlanNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoteSources() {
            if (this.remoteSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.remoteSources;
        }

        public final void setRemoteSources(Collection<String> remoteSources) {
            this.remoteSources = StringListCopier.copy(remoteSources);
        }

        @Override
        public final Builder remoteSources(Collection<String> remoteSources) {
            this.remoteSources = StringListCopier.copy(remoteSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteSources(String ... remoteSources) {
            this.remoteSources(Arrays.asList(remoteSources));
            return this;
        }

        public QueryStagePlanNode build() {
            return new QueryStagePlanNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryStagePlanNode> {
        public Builder name(String var1);

        public Builder identifier(String var1);

        public Builder children(Collection<QueryStagePlanNode> var1);

        public Builder children(QueryStagePlanNode ... var1);

        public Builder children(Consumer<Builder> ... var1);

        public Builder remoteSources(Collection<String> var1);

        public Builder remoteSources(String ... var1);
    }
}

