/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.CalculationExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CalculationStatus> {
    private static final SdkField<Instant> SUBMISSION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmissionDateTime").getter(CalculationStatus.getter(CalculationStatus::submissionDateTime)).setter(CalculationStatus.setter(Builder::submissionDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionDateTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDateTime").getter(CalculationStatus.getter(CalculationStatus::completionDateTime)).setter(CalculationStatus.setter(Builder::completionDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDateTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CalculationStatus.getter(CalculationStatus::stateAsString)).setter(CalculationStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateChangeReason").getter(CalculationStatus.getter(CalculationStatus::stateChangeReason)).setter(CalculationStatus.setter(Builder::stateChangeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMISSION_DATE_TIME_FIELD, COMPLETION_DATE_TIME_FIELD, STATE_FIELD, STATE_CHANGE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SubmissionDateTime", SUBMISSION_DATE_TIME_FIELD);
            this.put("CompletionDateTime", COMPLETION_DATE_TIME_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant submissionDateTime;
    private final Instant completionDateTime;
    private final String state;
    private final String stateChangeReason;

    private CalculationStatus(BuilderImpl builder) {
        this.submissionDateTime = builder.submissionDateTime;
        this.completionDateTime = builder.completionDateTime;
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    public final Instant submissionDateTime() {
        return this.submissionDateTime;
    }

    public final Instant completionDateTime() {
        return this.completionDateTime;
    }

    public final CalculationExecutionState state() {
        return CalculationExecutionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateChangeReason() {
        return this.stateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculationStatus)) {
            return false;
        }
        CalculationStatus other = (CalculationStatus)obj;
        return Objects.equals(this.submissionDateTime(), other.submissionDateTime()) && Objects.equals(this.completionDateTime(), other.completionDateTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason());
    }

    public final String toString() {
        return ToString.builder((String)"CalculationStatus").add("SubmissionDateTime", (Object)this.submissionDateTime()).add("CompletionDateTime", (Object)this.completionDateTime()).add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubmissionDateTime": {
                return Optional.ofNullable(clazz.cast(this.submissionDateTime()));
            }
            case "CompletionDateTime": {
                return Optional.ofNullable(clazz.cast(this.completionDateTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CalculationStatus, T> g) {
        return obj -> g.apply((CalculationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant submissionDateTime;
        private Instant completionDateTime;
        private String state;
        private String stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculationStatus model) {
            this.submissionDateTime(model.submissionDateTime);
            this.completionDateTime(model.completionDateTime);
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
        }

        public final Instant getSubmissionDateTime() {
            return this.submissionDateTime;
        }

        public final void setSubmissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
        }

        @Override
        public final Builder submissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
            return this;
        }

        public final Instant getCompletionDateTime() {
            return this.completionDateTime;
        }

        public final void setCompletionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
        }

        @Override
        public final Builder completionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CalculationExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateChangeReason() {
            return this.stateChangeReason;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public CalculationStatus build() {
            return new CalculationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CalculationStatus> {
        public Builder submissionDateTime(Instant var1);

        public Builder completionDateTime(Instant var1);

        public Builder state(String var1);

        public Builder state(CalculationExecutionState var1);

        public Builder stateChangeReason(String var1);
    }
}

