/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.TableMetadata;

public class ListTableMetadataPublisher
implements SdkPublisher<ListTableMetadataResponse> {
    private final AthenaAsyncClient client;
    private final ListTableMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTableMetadataPublisher(AthenaAsyncClient client, ListTableMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTableMetadataPublisher(AthenaAsyncClient client, ListTableMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTableMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTableMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableMetadata> tableMetadataList() {
        Function<ListTableMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableMetadataList() != null) {
                return response.tableMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTableMetadataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTableMetadataResponseFetcher
    implements AsyncPageFetcher<ListTableMetadataResponse> {
        private ListTableMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListTableMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTableMetadataResponse> nextPage(ListTableMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListTableMetadataPublisher.this.client.listTableMetadata(ListTableMetadataPublisher.this.firstRequest);
            }
            return ListTableMetadataPublisher.this.client.listTableMetadata((ListTableMetadataRequest)((Object)ListTableMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

