/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.NotebookType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportNotebookRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, ImportNotebookRequest> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(ImportNotebookRequest.getter(ImportNotebookRequest::workGroup)).setter(ImportNotebookRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ImportNotebookRequest.getter(ImportNotebookRequest::name)).setter(ImportNotebookRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Payload").getter(ImportNotebookRequest.getter(ImportNotebookRequest::payload)).setter(ImportNotebookRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ImportNotebookRequest.getter(ImportNotebookRequest::typeAsString)).setter(ImportNotebookRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NOTEBOOK_S3_LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookS3LocationUri").getter(ImportNotebookRequest.getter(ImportNotebookRequest::notebookS3LocationUri)).setter(ImportNotebookRequest.setter(Builder::notebookS3LocationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookS3LocationUri").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(ImportNotebookRequest.getter(ImportNotebookRequest::clientRequestToken)).setter(ImportNotebookRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD, NAME_FIELD, PAYLOAD_FIELD, TYPE_FIELD, NOTEBOOK_S3_LOCATION_URI_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String workGroup;
    private final String name;
    private final String payload;
    private final String type;
    private final String notebookS3LocationUri;
    private final String clientRequestToken;

    private ImportNotebookRequest(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
        this.name = builder.name;
        this.payload = builder.payload;
        this.type = builder.type;
        this.notebookS3LocationUri = builder.notebookS3LocationUri;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public final String name() {
        return this.name;
    }

    public final String payload() {
        return this.payload;
    }

    public final NotebookType type() {
        return NotebookType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String notebookS3LocationUri() {
        return this.notebookS3LocationUri;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookS3LocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportNotebookRequest)) {
            return false;
        }
        ImportNotebookRequest other = (ImportNotebookRequest)((Object)obj);
        return Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.notebookS3LocationUri(), other.notebookS3LocationUri()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"ImportNotebookRequest").add("WorkGroup", (Object)this.workGroup()).add("Name", (Object)this.name()).add("Payload", (Object)this.payload()).add("Type", (Object)this.typeAsString()).add("NotebookS3LocationUri", (Object)this.notebookS3LocationUri()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "NotebookS3LocationUri": {
                return Optional.ofNullable(clazz.cast(this.notebookS3LocationUri()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportNotebookRequest, T> g) {
        return obj -> g.apply((ImportNotebookRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String workGroup;
        private String name;
        private String payload;
        private String type;
        private String notebookS3LocationUri;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportNotebookRequest model) {
            super(model);
            this.workGroup(model.workGroup);
            this.name(model.name);
            this.payload(model.payload);
            this.type(model.type);
            this.notebookS3LocationUri(model.notebookS3LocationUri);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPayload() {
            return this.payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotebookType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNotebookS3LocationUri() {
            return this.notebookS3LocationUri;
        }

        public final void setNotebookS3LocationUri(String notebookS3LocationUri) {
            this.notebookS3LocationUri = notebookS3LocationUri;
        }

        @Override
        public final Builder notebookS3LocationUri(String notebookS3LocationUri) {
            this.notebookS3LocationUri = notebookS3LocationUri;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportNotebookRequest build() {
            return new ImportNotebookRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportNotebookRequest> {
        public Builder workGroup(String var1);

        public Builder name(String var1);

        public Builder payload(String var1);

        public Builder type(String var1);

        public Builder type(NotebookType var1);

        public Builder notebookS3LocationUri(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

