/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.AthenaAsyncClientBuilder;
import software.amazon.awssdk.services.athena.AthenaServiceClientConfiguration;
import software.amazon.awssdk.services.athena.DefaultAthenaAsyncClient;
import software.amazon.awssdk.services.athena.DefaultAthenaBaseClientBuilder;
import software.amazon.awssdk.services.athena.endpoints.AthenaEndpointProvider;

@SdkInternalApi
final class DefaultAthenaAsyncClientBuilder
extends DefaultAthenaBaseClientBuilder<AthenaAsyncClientBuilder, AthenaAsyncClient>
implements AthenaAsyncClientBuilder {
    DefaultAthenaAsyncClientBuilder() {
    }

    @Override
    public DefaultAthenaAsyncClientBuilder endpointProvider(AthenaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AthenaAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAthenaAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AthenaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAthenaAsyncClient client = new DefaultAthenaAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AthenaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AthenaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

