/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.AthenaAsyncClientBuilder;
import software.amazon.awssdk.services.athena.AthenaServiceClientConfiguration;
import software.amazon.awssdk.services.athena.DefaultAthenaAsyncClient;
import software.amazon.awssdk.services.athena.DefaultAthenaBaseClientBuilder;
import software.amazon.awssdk.services.athena.endpoints.AthenaEndpointProvider;

@SdkInternalApi
final class DefaultAthenaAsyncClientBuilder
extends DefaultAthenaBaseClientBuilder<AthenaAsyncClientBuilder, AthenaAsyncClient>
implements AthenaAsyncClientBuilder {
    DefaultAthenaAsyncClientBuilder() {
    }

    @Override
    public DefaultAthenaAsyncClientBuilder endpointProvider(AthenaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AthenaAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAthenaAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AthenaServiceClientConfiguration serviceClientConfiguration = AthenaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAthenaAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

