/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.PreparedStatement;
import software.amazon.awssdk.services.athena.model.PreparedStatementDetailsListCopier;
import software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementName;
import software.amazon.awssdk.services.athena.model.UnprocessedPreparedStatementNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetPreparedStatementResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, BatchGetPreparedStatementResponse> {
    private static final SdkField<List<PreparedStatement>> PREPARED_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreparedStatements").getter(BatchGetPreparedStatementResponse.getter(BatchGetPreparedStatementResponse::preparedStatements)).setter(BatchGetPreparedStatementResponse.setter(Builder::preparedStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreparedStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PreparedStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedPreparedStatementName>> UNPROCESSED_PREPARED_STATEMENT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedPreparedStatementNames").getter(BatchGetPreparedStatementResponse.getter(BatchGetPreparedStatementResponse::unprocessedPreparedStatementNames)).setter(BatchGetPreparedStatementResponse.setter(Builder::unprocessedPreparedStatementNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedPreparedStatementNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedPreparedStatementName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREPARED_STATEMENTS_FIELD, UNPROCESSED_PREPARED_STATEMENT_NAMES_FIELD));
    private final List<PreparedStatement> preparedStatements;
    private final List<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames;

    private BatchGetPreparedStatementResponse(BuilderImpl builder) {
        super(builder);
        this.preparedStatements = builder.preparedStatements;
        this.unprocessedPreparedStatementNames = builder.unprocessedPreparedStatementNames;
    }

    public final boolean hasPreparedStatements() {
        return this.preparedStatements != null && !(this.preparedStatements instanceof SdkAutoConstructList);
    }

    public final List<PreparedStatement> preparedStatements() {
        return this.preparedStatements;
    }

    public final boolean hasUnprocessedPreparedStatementNames() {
        return this.unprocessedPreparedStatementNames != null && !(this.unprocessedPreparedStatementNames instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames() {
        return this.unprocessedPreparedStatementNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreparedStatements() ? this.preparedStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedPreparedStatementNames() ? this.unprocessedPreparedStatementNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPreparedStatementResponse)) {
            return false;
        }
        BatchGetPreparedStatementResponse other = (BatchGetPreparedStatementResponse)((Object)obj);
        return this.hasPreparedStatements() == other.hasPreparedStatements() && Objects.equals(this.preparedStatements(), other.preparedStatements()) && this.hasUnprocessedPreparedStatementNames() == other.hasUnprocessedPreparedStatementNames() && Objects.equals(this.unprocessedPreparedStatementNames(), other.unprocessedPreparedStatementNames());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetPreparedStatementResponse").add("PreparedStatements", this.hasPreparedStatements() ? this.preparedStatements() : null).add("UnprocessedPreparedStatementNames", this.hasUnprocessedPreparedStatementNames() ? this.unprocessedPreparedStatementNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreparedStatements": {
                return Optional.ofNullable(clazz.cast(this.preparedStatements()));
            }
            case "UnprocessedPreparedStatementNames": {
                return Optional.ofNullable(clazz.cast(this.unprocessedPreparedStatementNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPreparedStatementResponse, T> g) {
        return obj -> g.apply((BatchGetPreparedStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<PreparedStatement> preparedStatements = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPreparedStatementResponse model) {
            super(model);
            this.preparedStatements(model.preparedStatements);
            this.unprocessedPreparedStatementNames(model.unprocessedPreparedStatementNames);
        }

        public final List<PreparedStatement.Builder> getPreparedStatements() {
            List<PreparedStatement.Builder> result = PreparedStatementDetailsListCopier.copyToBuilder(this.preparedStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreparedStatements(Collection<PreparedStatement.BuilderImpl> preparedStatements) {
            this.preparedStatements = PreparedStatementDetailsListCopier.copyFromBuilder(preparedStatements);
        }

        @Override
        public final Builder preparedStatements(Collection<PreparedStatement> preparedStatements) {
            this.preparedStatements = PreparedStatementDetailsListCopier.copy(preparedStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preparedStatements(PreparedStatement ... preparedStatements) {
            this.preparedStatements(Arrays.asList(preparedStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preparedStatements(Consumer<PreparedStatement.Builder> ... preparedStatements) {
            this.preparedStatements(Stream.of(preparedStatements).map(c -> (PreparedStatement)((PreparedStatement.Builder)PreparedStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedPreparedStatementName.Builder> getUnprocessedPreparedStatementNames() {
            List<UnprocessedPreparedStatementName.Builder> result = UnprocessedPreparedStatementNameListCopier.copyToBuilder(this.unprocessedPreparedStatementNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedPreparedStatementNames(Collection<UnprocessedPreparedStatementName.BuilderImpl> unprocessedPreparedStatementNames) {
            this.unprocessedPreparedStatementNames = UnprocessedPreparedStatementNameListCopier.copyFromBuilder(unprocessedPreparedStatementNames);
        }

        @Override
        public final Builder unprocessedPreparedStatementNames(Collection<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames) {
            this.unprocessedPreparedStatementNames = UnprocessedPreparedStatementNameListCopier.copy(unprocessedPreparedStatementNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedPreparedStatementNames(UnprocessedPreparedStatementName ... unprocessedPreparedStatementNames) {
            this.unprocessedPreparedStatementNames(Arrays.asList(unprocessedPreparedStatementNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedPreparedStatementNames(Consumer<UnprocessedPreparedStatementName.Builder> ... unprocessedPreparedStatementNames) {
            this.unprocessedPreparedStatementNames(Stream.of(unprocessedPreparedStatementNames).map(c -> (UnprocessedPreparedStatementName)((UnprocessedPreparedStatementName.Builder)UnprocessedPreparedStatementName.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetPreparedStatementResponse build() {
            return new BatchGetPreparedStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetPreparedStatementResponse> {
        public Builder preparedStatements(Collection<PreparedStatement> var1);

        public Builder preparedStatements(PreparedStatement ... var1);

        public Builder preparedStatements(Consumer<PreparedStatement.Builder> ... var1);

        public Builder unprocessedPreparedStatementNames(Collection<UnprocessedPreparedStatementName> var1);

        public Builder unprocessedPreparedStatementNames(UnprocessedPreparedStatementName ... var1);

        public Builder unprocessedPreparedStatementNames(Consumer<UnprocessedPreparedStatementName.Builder> ... var1);
    }
}

