/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.DataCatalogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCatalogSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCatalogSummary> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogName").getter(DataCatalogSummary.getter(DataCatalogSummary::catalogName)).setter(DataCatalogSummary.setter(Builder::catalogName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DataCatalogSummary.getter(DataCatalogSummary::typeAsString)).setter(DataCatalogSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_NAME_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogName;
    private final String type;

    private DataCatalogSummary(BuilderImpl builder) {
        this.catalogName = builder.catalogName;
        this.type = builder.type;
    }

    public final String catalogName() {
        return this.catalogName;
    }

    public final DataCatalogType type() {
        return DataCatalogType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogSummary)) {
            return false;
        }
        DataCatalogSummary other = (DataCatalogSummary)obj;
        return Objects.equals(this.catalogName(), other.catalogName()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataCatalogSummary").add("CatalogName", (Object)this.catalogName()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogName": {
                return Optional.ofNullable(clazz.cast(this.catalogName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogSummary, T> g) {
        return obj -> g.apply((DataCatalogSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogName;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogSummary model) {
            this.catalogName(model.catalogName);
            this.type(model.type);
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataCatalogType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public DataCatalogSummary build() {
            return new DataCatalogSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCatalogSummary> {
        public Builder catalogName(String var1);

        public Builder type(String var1);

        public Builder type(DataCatalogType var1);
    }
}

