/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;

public class ListWorkGroupsPublisher
implements SdkPublisher<ListWorkGroupsResponse> {
    private final AthenaAsyncClient client;
    private final ListWorkGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkGroupsPublisher(AthenaAsyncClient client, ListWorkGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkGroupsPublisher(AthenaAsyncClient client, ListWorkGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWorkGroupsResponseFetcher
    implements AsyncPageFetcher<ListWorkGroupsResponse> {
        private ListWorkGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkGroupsResponse> nextPage(ListWorkGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkGroupsPublisher.this.client.listWorkGroups(ListWorkGroupsPublisher.this.firstRequest);
            }
            return ListWorkGroupsPublisher.this.client.listWorkGroups((ListWorkGroupsRequest)((Object)ListWorkGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

