/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueryExecutionsResponse extends AthenaResponse implements
        ToCopyableBuilder<ListQueryExecutionsResponse.Builder, ListQueryExecutionsResponse> {
    private static final SdkField<List<String>> QUERY_EXECUTION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueryExecutionIds")
            .getter(getter(ListQueryExecutionsResponse::queryExecutionIds))
            .setter(setter(Builder::queryExecutionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQueryExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTION_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> queryExecutionIds;

    private final String nextToken;

    private ListQueryExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.queryExecutionIds = builder.queryExecutionIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the QueryExecutionIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasQueryExecutionIds() {
        return queryExecutionIds != null && !(queryExecutionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique IDs of each query execution as an array of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueryExecutionIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The unique IDs of each query execution as an array of strings.
     */
    public final List<String> queryExecutionIds() {
        return queryExecutionIds;
    }

    /**
     * <p>
     * A token to be used by the next request if this request is truncated.
     * </p>
     * 
     * @return A token to be used by the next request if this request is truncated.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryExecutionIds() ? queryExecutionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryExecutionsResponse)) {
            return false;
        }
        ListQueryExecutionsResponse other = (ListQueryExecutionsResponse) obj;
        return hasQueryExecutionIds() == other.hasQueryExecutionIds()
                && Objects.equals(queryExecutionIds(), other.queryExecutionIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueryExecutionsResponse")
                .add("QueryExecutionIds", hasQueryExecutionIds() ? queryExecutionIds() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryExecutionIds":
            return Optional.ofNullable(clazz.cast(queryExecutionIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueryExecutionsResponse, T> g) {
        return obj -> g.apply((ListQueryExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQueryExecutionsResponse> {
        /**
         * <p>
         * The unique IDs of each query execution as an array of strings.
         * </p>
         * 
         * @param queryExecutionIds
         *        The unique IDs of each query execution as an array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryExecutionIds(Collection<String> queryExecutionIds);

        /**
         * <p>
         * The unique IDs of each query execution as an array of strings.
         * </p>
         * 
         * @param queryExecutionIds
         *        The unique IDs of each query execution as an array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryExecutionIds(String... queryExecutionIds);

        /**
         * <p>
         * A token to be used by the next request if this request is truncated.
         * </p>
         * 
         * @param nextToken
         *        A token to be used by the next request if this request is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<String> queryExecutionIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryExecutionsResponse model) {
            super(model);
            queryExecutionIds(model.queryExecutionIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getQueryExecutionIds() {
            if (queryExecutionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return queryExecutionIds;
        }

        @Override
        public final Builder queryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutionIds(String... queryExecutionIds) {
            queryExecutionIds(Arrays.asList(queryExecutionIds));
            return this;
        }

        public final void setQueryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQueryExecutionsResponse build() {
            return new ListQueryExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
