/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngineVersionsResponse extends AthenaResponse implements
        ToCopyableBuilder<ListEngineVersionsResponse.Builder, ListEngineVersionsResponse> {
    private static final SdkField<List<EngineVersion>> ENGINE_VERSIONS_FIELD = SdkField
            .<List<EngineVersion>> builder(MarshallingType.LIST)
            .memberName("EngineVersions")
            .getter(getter(ListEngineVersionsResponse::engineVersions))
            .setter(setter(Builder::engineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngineVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EngineVersion> engineVersions;

    private final String nextToken;

    private ListEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.engineVersions = builder.engineVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EngineVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEngineVersions() {
        return engineVersions != null && !(engineVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of engine versions that are available to choose from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEngineVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of engine versions that are available to choose from.
     */
    public final List<EngineVersion> engineVersions() {
        return engineVersions;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEngineVersions() ? engineVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngineVersionsResponse)) {
            return false;
        }
        ListEngineVersionsResponse other = (ListEngineVersionsResponse) obj;
        return hasEngineVersions() == other.hasEngineVersions() && Objects.equals(engineVersions(), other.engineVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngineVersionsResponse")
                .add("EngineVersions", hasEngineVersions() ? engineVersions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineVersions":
            return Optional.ofNullable(clazz.cast(engineVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEngineVersionsResponse, T> g) {
        return obj -> g.apply((ListEngineVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEngineVersionsResponse> {
        /**
         * <p>
         * A list of engine versions that are available to choose from.
         * </p>
         * 
         * @param engineVersions
         *        A list of engine versions that are available to choose from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(Collection<EngineVersion> engineVersions);

        /**
         * <p>
         * A list of engine versions that are available to choose from.
         * </p>
         * 
         * @param engineVersions
         *        A list of engine versions that are available to choose from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(EngineVersion... engineVersions);

        /**
         * <p>
         * A list of engine versions that are available to choose from.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EngineVersion>.Builder} avoiding the need
         * to create one manually via {@link List<EngineVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EngineVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #engineVersions(List<EngineVersion>)}.
         * 
         * @param engineVersions
         *        a consumer that will call methods on {@link List<EngineVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersions(List<EngineVersion>)
         */
        Builder engineVersions(Consumer<EngineVersion.Builder>... engineVersions);

        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of
         * the previous page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the
         *        response object of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<EngineVersion> engineVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngineVersionsResponse model) {
            super(model);
            engineVersions(model.engineVersions);
            nextToken(model.nextToken);
        }

        public final Collection<EngineVersion.Builder> getEngineVersions() {
            if (engineVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return engineVersions != null ? engineVersions.stream().map(EngineVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder engineVersions(Collection<EngineVersion> engineVersions) {
            this.engineVersions = EngineVersionsListCopier.copy(engineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(EngineVersion... engineVersions) {
            engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersion.Builder>... engineVersions) {
            engineVersions(Stream.of(engineVersions).map(c -> EngineVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEngineVersions(Collection<EngineVersion.BuilderImpl> engineVersions) {
            this.engineVersions = EngineVersionsListCopier.copyFromBuilder(engineVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEngineVersionsResponse build() {
            return new ListEngineVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
