/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatistics;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatus;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.services.athena.model.StatementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryExecution> {
    private static final SdkField<String> QUERY_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryExecutionId").getter(QueryExecution.getter(QueryExecution::queryExecutionId)).setter(QueryExecution.setter(Builder::queryExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionId").build()}).build();
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Query").getter(QueryExecution.getter(QueryExecution::query)).setter(QueryExecution.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()}).build();
    private static final SdkField<String> STATEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementType").getter(QueryExecution.getter(QueryExecution::statementTypeAsString)).setter(QueryExecution.setter(Builder::statementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementType").build()}).build();
    private static final SdkField<ResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultConfiguration").getter(QueryExecution.getter(QueryExecution::resultConfiguration)).setter(QueryExecution.setter(Builder::resultConfiguration)).constructor(ResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfiguration").build()}).build();
    private static final SdkField<QueryExecutionContext> QUERY_EXECUTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryExecutionContext").getter(QueryExecution.getter(QueryExecution::queryExecutionContext)).setter(QueryExecution.setter(Builder::queryExecutionContext)).constructor(QueryExecutionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionContext").build()}).build();
    private static final SdkField<QueryExecutionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(QueryExecution.getter(QueryExecution::status)).setter(QueryExecution.setter(Builder::status)).constructor(QueryExecutionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<QueryExecutionStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(QueryExecution.getter(QueryExecution::statistics)).setter(QueryExecution.setter(Builder::statistics)).constructor(QueryExecutionStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(QueryExecution.getter(QueryExecution::workGroup)).setter(QueryExecution.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTION_ID_FIELD, QUERY_FIELD, STATEMENT_TYPE_FIELD, RESULT_CONFIGURATION_FIELD, QUERY_EXECUTION_CONTEXT_FIELD, STATUS_FIELD, STATISTICS_FIELD, WORK_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String queryExecutionId;
    private final String query;
    private final String statementType;
    private final ResultConfiguration resultConfiguration;
    private final QueryExecutionContext queryExecutionContext;
    private final QueryExecutionStatus status;
    private final QueryExecutionStatistics statistics;
    private final String workGroup;

    private QueryExecution(BuilderImpl builder) {
        this.queryExecutionId = builder.queryExecutionId;
        this.query = builder.query;
        this.statementType = builder.statementType;
        this.resultConfiguration = builder.resultConfiguration;
        this.queryExecutionContext = builder.queryExecutionContext;
        this.status = builder.status;
        this.statistics = builder.statistics;
        this.workGroup = builder.workGroup;
    }

    public String queryExecutionId() {
        return this.queryExecutionId;
    }

    public String query() {
        return this.query;
    }

    public StatementType statementType() {
        return StatementType.fromValue(this.statementType);
    }

    public String statementTypeAsString() {
        return this.statementType;
    }

    public ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public QueryExecutionContext queryExecutionContext() {
        return this.queryExecutionContext;
    }

    public QueryExecutionStatus status() {
        return this.status;
    }

    public QueryExecutionStatistics statistics() {
        return this.statistics;
    }

    public String workGroup() {
        return this.workGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecution)) {
            return false;
        }
        QueryExecution other = (QueryExecution)obj;
        return Objects.equals(this.queryExecutionId(), other.queryExecutionId()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.statementTypeAsString(), other.statementTypeAsString()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.queryExecutionContext(), other.queryExecutionContext()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.workGroup(), other.workGroup());
    }

    public String toString() {
        return ToString.builder((String)"QueryExecution").add("QueryExecutionId", (Object)this.queryExecutionId()).add("Query", (Object)this.query()).add("StatementType", (Object)this.statementTypeAsString()).add("ResultConfiguration", (Object)this.resultConfiguration()).add("QueryExecutionContext", (Object)this.queryExecutionContext()).add("Status", (Object)this.status()).add("Statistics", (Object)this.statistics()).add("WorkGroup", (Object)this.workGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionId": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionId()));
            }
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "StatementType": {
                return Optional.ofNullable(clazz.cast(this.statementTypeAsString()));
            }
            case "ResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "QueryExecutionContext": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionContext()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecution, T> g) {
        return obj -> g.apply((QueryExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryExecutionId;
        private String query;
        private String statementType;
        private ResultConfiguration resultConfiguration;
        private QueryExecutionContext queryExecutionContext;
        private QueryExecutionStatus status;
        private QueryExecutionStatistics statistics;
        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecution model) {
            this.queryExecutionId(model.queryExecutionId);
            this.query(model.query);
            this.statementType(model.statementType);
            this.resultConfiguration(model.resultConfiguration);
            this.queryExecutionContext(model.queryExecutionContext);
            this.status(model.status);
            this.statistics(model.statistics);
            this.workGroup(model.workGroup);
        }

        public final String getQueryExecutionId() {
            return this.queryExecutionId;
        }

        @Override
        public final Builder queryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
            return this;
        }

        public final void setQueryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final String getStatementType() {
            return this.statementType;
        }

        @Override
        public final Builder statementType(String statementType) {
            this.statementType = statementType;
            return this;
        }

        @Override
        public final Builder statementType(StatementType statementType) {
            this.statementType(statementType == null ? null : statementType.toString());
            return this;
        }

        public final void setStatementType(String statementType) {
            this.statementType = statementType;
        }

        public final ResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final void setResultConfiguration(ResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        public final QueryExecutionContext.Builder getQueryExecutionContext() {
            return this.queryExecutionContext != null ? this.queryExecutionContext.toBuilder() : null;
        }

        @Override
        public final Builder queryExecutionContext(QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
            return this;
        }

        public final void setQueryExecutionContext(QueryExecutionContext.BuilderImpl queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext != null ? queryExecutionContext.build() : null;
        }

        public final QueryExecutionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(QueryExecutionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(QueryExecutionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final QueryExecutionStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(QueryExecutionStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(QueryExecutionStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        public QueryExecution build() {
            return new QueryExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryExecution> {
        public Builder queryExecutionId(String var1);

        public Builder query(String var1);

        public Builder statementType(String var1);

        public Builder statementType(StatementType var1);

        public Builder resultConfiguration(ResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ResultConfiguration)((ResultConfiguration.Builder)ResultConfiguration.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder queryExecutionContext(QueryExecutionContext var1);

        default public Builder queryExecutionContext(Consumer<QueryExecutionContext.Builder> queryExecutionContext) {
            return this.queryExecutionContext((QueryExecutionContext)((QueryExecutionContext.Builder)QueryExecutionContext.builder().applyMutation(queryExecutionContext)).build());
        }

        public Builder status(QueryExecutionStatus var1);

        default public Builder status(Consumer<QueryExecutionStatus.Builder> status) {
            return this.status((QueryExecutionStatus)((QueryExecutionStatus.Builder)QueryExecutionStatus.builder().applyMutation(status)).build());
        }

        public Builder statistics(QueryExecutionStatistics var1);

        default public Builder statistics(Consumer<QueryExecutionStatistics.Builder> statistics) {
            return this.statistics((QueryExecutionStatistics)((QueryExecutionStatistics.Builder)QueryExecutionStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder workGroup(String var1);
    }
}

