/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.NamedQueryIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNamedQueriesResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListNamedQueriesResponse> {
    private static final SdkField<List<String>> NAMED_QUERY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NamedQueryIds").getter(ListNamedQueriesResponse.getter(ListNamedQueriesResponse::namedQueryIds)).setter(ListNamedQueriesResponse.setter(Builder::namedQueryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNamedQueriesResponse.getter(ListNamedQueriesResponse::nextToken)).setter(ListNamedQueriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> namedQueryIds;
    private final String nextToken;

    private ListNamedQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.namedQueryIds = builder.namedQueryIds;
        this.nextToken = builder.nextToken;
    }

    public boolean hasNamedQueryIds() {
        return this.namedQueryIds != null && !(this.namedQueryIds instanceof SdkAutoConstructList);
    }

    public List<String> namedQueryIds() {
        return this.namedQueryIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namedQueryIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamedQueriesResponse)) {
            return false;
        }
        ListNamedQueriesResponse other = (ListNamedQueriesResponse)((Object)obj);
        return Objects.equals(this.namedQueryIds(), other.namedQueryIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListNamedQueriesResponse").add("NamedQueryIds", this.namedQueryIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueryIds": {
                return Optional.ofNullable(clazz.cast(this.namedQueryIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNamedQueriesResponse, T> g) {
        return obj -> g.apply((ListNamedQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<String> namedQueryIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamedQueriesResponse model) {
            super(model);
            this.namedQueryIds(model.namedQueryIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getNamedQueryIds() {
            return this.namedQueryIds;
        }

        @Override
        public final Builder namedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueryIds(String ... namedQueryIds) {
            this.namedQueryIds(Arrays.asList(namedQueryIds));
            return this;
        }

        public final void setNamedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNamedQueriesResponse build() {
            return new ListNamedQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNamedQueriesResponse> {
        public Builder namedQueryIds(Collection<String> var1);

        public Builder namedQueryIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

