/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.services.athena.model.DataCatalogSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataCatalogsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListDataCatalogsResponse> {
    private static final SdkField<List<DataCatalogSummary>> DATA_CATALOGS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDataCatalogsResponse.getter(ListDataCatalogsResponse::dataCatalogsSummary)).setter(ListDataCatalogsResponse.setter(Builder::dataCatalogsSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogsSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataCatalogSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDataCatalogsResponse.getter(ListDataCatalogsResponse::nextToken)).setter(ListDataCatalogsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_CATALOGS_SUMMARY_FIELD, NEXT_TOKEN_FIELD));
    private final List<DataCatalogSummary> dataCatalogsSummary;
    private final String nextToken;

    private ListDataCatalogsResponse(BuilderImpl builder) {
        super(builder);
        this.dataCatalogsSummary = builder.dataCatalogsSummary;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDataCatalogsSummary() {
        return this.dataCatalogsSummary != null && !(this.dataCatalogsSummary instanceof SdkAutoConstructList);
    }

    public List<DataCatalogSummary> dataCatalogsSummary() {
        return this.dataCatalogsSummary;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCatalogsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataCatalogsResponse)) {
            return false;
        }
        ListDataCatalogsResponse other = (ListDataCatalogsResponse)((Object)obj);
        return Objects.equals(this.dataCatalogsSummary(), other.dataCatalogsSummary()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDataCatalogsResponse").add("DataCatalogsSummary", this.dataCatalogsSummary()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataCatalogsSummary": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogsSummary()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataCatalogsResponse, T> g) {
        return obj -> g.apply((ListDataCatalogsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<DataCatalogSummary> dataCatalogsSummary = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataCatalogsResponse model) {
            super(model);
            this.dataCatalogsSummary(model.dataCatalogsSummary);
            this.nextToken(model.nextToken);
        }

        public final Collection<DataCatalogSummary.Builder> getDataCatalogsSummary() {
            return this.dataCatalogsSummary != null ? (Collection)this.dataCatalogsSummary.stream().map(DataCatalogSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataCatalogsSummary(Collection<DataCatalogSummary> dataCatalogsSummary) {
            this.dataCatalogsSummary = DataCatalogSummaryListCopier.copy(dataCatalogsSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogsSummary(DataCatalogSummary ... dataCatalogsSummary) {
            this.dataCatalogsSummary(Arrays.asList(dataCatalogsSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogsSummary(Consumer<DataCatalogSummary.Builder> ... dataCatalogsSummary) {
            this.dataCatalogsSummary(Stream.of(dataCatalogsSummary).map(c -> (DataCatalogSummary)((DataCatalogSummary.Builder)DataCatalogSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataCatalogsSummary(Collection<DataCatalogSummary.BuilderImpl> dataCatalogsSummary) {
            this.dataCatalogsSummary = DataCatalogSummaryListCopier.copyFromBuilder(dataCatalogsSummary);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataCatalogsResponse build() {
            return new ListDataCatalogsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataCatalogsResponse> {
        public Builder dataCatalogsSummary(Collection<DataCatalogSummary> var1);

        public Builder dataCatalogsSummary(DataCatalogSummary ... var1);

        public Builder dataCatalogsSummary(Consumer<DataCatalogSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

