/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a named query ID that could not be processed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessedNamedQueryId implements SdkPojo, Serializable,
        ToCopyableBuilder<UnprocessedNamedQueryId.Builder, UnprocessedNamedQueryId> {
    private static final SdkField<String> NAMED_QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnprocessedNamedQueryId::namedQueryId)).setter(setter(Builder::namedQueryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnprocessedNamedQueryId::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnprocessedNamedQueryId::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_ID_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namedQueryId;

    private final String errorCode;

    private final String errorMessage;

    private UnprocessedNamedQueryId(BuilderImpl builder) {
        this.namedQueryId = builder.namedQueryId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The unique identifier of the named query.
     * </p>
     * 
     * @return The unique identifier of the named query.
     */
    public String namedQueryId() {
        return namedQueryId;
    }

    /**
     * <p>
     * The error code returned when the processing request for the named query failed, if applicable.
     * </p>
     * 
     * @return The error code returned when the processing request for the named query failed, if applicable.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message returned when the processing request for the named query failed, if applicable.
     * </p>
     * 
     * @return The error message returned when the processing request for the named query failed, if applicable.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namedQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedNamedQueryId)) {
            return false;
        }
        UnprocessedNamedQueryId other = (UnprocessedNamedQueryId) obj;
        return Objects.equals(namedQueryId(), other.namedQueryId()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UnprocessedNamedQueryId").add("NamedQueryId", namedQueryId()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamedQueryId":
            return Optional.ofNullable(clazz.cast(namedQueryId()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedNamedQueryId, T> g) {
        return obj -> g.apply((UnprocessedNamedQueryId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessedNamedQueryId> {
        /**
         * <p>
         * The unique identifier of the named query.
         * </p>
         * 
         * @param namedQueryId
         *        The unique identifier of the named query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryId(String namedQueryId);

        /**
         * <p>
         * The error code returned when the processing request for the named query failed, if applicable.
         * </p>
         * 
         * @param errorCode
         *        The error code returned when the processing request for the named query failed, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message returned when the processing request for the named query failed, if applicable.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned when the processing request for the named query failed, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String namedQueryId;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedNamedQueryId model) {
            namedQueryId(model.namedQueryId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getNamedQueryId() {
            return namedQueryId;
        }

        @Override
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public UnprocessedNamedQueryId build() {
            return new UnprocessedNamedQueryId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
