/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary information for the data catalog, which includes its name and type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCatalogSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCatalogSummary.Builder, DataCatalogSummary> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataCatalogSummary::catalogName)).setter(setter(Builder::catalogName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataCatalogSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CATALOG_NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogName;

    private final String type;

    private DataCatalogSummary(BuilderImpl builder) {
        this.catalogName = builder.catalogName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the data catalog.
     * </p>
     * 
     * @return The name of the data catalog.
     */
    public String catalogName() {
        return catalogName;
    }

    /**
     * <p>
     * The data catalog type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataCatalogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data catalog type.
     * @see DataCatalogType
     */
    public DataCatalogType type() {
        return DataCatalogType.fromValue(type);
    }

    /**
     * <p>
     * The data catalog type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataCatalogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data catalog type.
     * @see DataCatalogType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogSummary)) {
            return false;
        }
        DataCatalogSummary other = (DataCatalogSummary) obj;
        return Objects.equals(catalogName(), other.catalogName()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataCatalogSummary").add("CatalogName", catalogName()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogName":
            return Optional.ofNullable(clazz.cast(catalogName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogSummary, T> g) {
        return obj -> g.apply((DataCatalogSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCatalogSummary> {
        /**
         * <p>
         * The name of the data catalog.
         * </p>
         * 
         * @param catalogName
         *        The name of the data catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogName(String catalogName);

        /**
         * <p>
         * The data catalog type.
         * </p>
         * 
         * @param type
         *        The data catalog type.
         * @see DataCatalogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCatalogType
         */
        Builder type(String type);

        /**
         * <p>
         * The data catalog type.
         * </p>
         * 
         * @param type
         *        The data catalog type.
         * @see DataCatalogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCatalogType
         */
        Builder type(DataCatalogType type);
    }

    static final class BuilderImpl implements Builder {
        private String catalogName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogSummary model) {
            catalogName(model.catalogName);
            type(model.type);
        }

        public final String getCatalogName() {
            return catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataCatalogType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public DataCatalogSummary build() {
            return new DataCatalogSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
