/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates;
import software.amazon.awssdk.services.athena.model.WorkGroupState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkGroupRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, UpdateWorkGroupRequest> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateWorkGroupRequest.getter(UpdateWorkGroupRequest::workGroup)).setter(UpdateWorkGroupRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateWorkGroupRequest.getter(UpdateWorkGroupRequest::description)).setter(UpdateWorkGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<WorkGroupConfigurationUpdates> CONFIGURATION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateWorkGroupRequest.getter(UpdateWorkGroupRequest::configurationUpdates)).setter(UpdateWorkGroupRequest.setter(Builder::configurationUpdates)).constructor(WorkGroupConfigurationUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationUpdates").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateWorkGroupRequest.getter(UpdateWorkGroupRequest::stateAsString)).setter(UpdateWorkGroupRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD, DESCRIPTION_FIELD, CONFIGURATION_UPDATES_FIELD, STATE_FIELD));
    private final String workGroup;
    private final String description;
    private final WorkGroupConfigurationUpdates configurationUpdates;
    private final String state;

    private UpdateWorkGroupRequest(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
        this.description = builder.description;
        this.configurationUpdates = builder.configurationUpdates;
        this.state = builder.state;
    }

    public String workGroup() {
        return this.workGroup;
    }

    public String description() {
        return this.description;
    }

    public WorkGroupConfigurationUpdates configurationUpdates() {
        return this.configurationUpdates;
    }

    public WorkGroupState state() {
        return WorkGroupState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkGroupRequest)) {
            return false;
        }
        UpdateWorkGroupRequest other = (UpdateWorkGroupRequest)((Object)obj);
        return Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.configurationUpdates(), other.configurationUpdates()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateWorkGroupRequest").add("WorkGroup", (Object)this.workGroup()).add("Description", (Object)this.description()).add("ConfigurationUpdates", (Object)this.configurationUpdates()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ConfigurationUpdates": {
                return Optional.ofNullable(clazz.cast(this.configurationUpdates()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkGroupRequest, T> g) {
        return obj -> g.apply((UpdateWorkGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String workGroup;
        private String description;
        private WorkGroupConfigurationUpdates configurationUpdates;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkGroupRequest model) {
            super(model);
            this.workGroup(model.workGroup);
            this.description(model.description);
            this.configurationUpdates(model.configurationUpdates);
            this.state(model.state);
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final WorkGroupConfigurationUpdates.Builder getConfigurationUpdates() {
            return this.configurationUpdates != null ? this.configurationUpdates.toBuilder() : null;
        }

        @Override
        public final Builder configurationUpdates(WorkGroupConfigurationUpdates configurationUpdates) {
            this.configurationUpdates = configurationUpdates;
            return this;
        }

        public final void setConfigurationUpdates(WorkGroupConfigurationUpdates.BuilderImpl configurationUpdates) {
            this.configurationUpdates = configurationUpdates != null ? configurationUpdates.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkGroupRequest build() {
            return new UpdateWorkGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkGroupRequest> {
        public Builder workGroup(String var1);

        public Builder description(String var1);

        public Builder configurationUpdates(WorkGroupConfigurationUpdates var1);

        default public Builder configurationUpdates(Consumer<WorkGroupConfigurationUpdates.Builder> configurationUpdates) {
            return this.configurationUpdates((WorkGroupConfigurationUpdates)((WorkGroupConfigurationUpdates.Builder)WorkGroupConfigurationUpdates.builder().applyMutation(configurationUpdates)).build());
        }

        public Builder state(String var1);

        public Builder state(WorkGroupState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

