/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata and rows that comprise a query result set. The metadata describes the column structure and data types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultSet implements SdkPojo, Serializable, ToCopyableBuilder<ResultSet.Builder, ResultSet> {
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField
            .<List<Row>> builder(MarshallingType.LIST)
            .getter(getter(ResultSet::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Row> builder(MarshallingType.SDK_POJO)
                                            .constructor(Row::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResultSetMetadata> RESULT_SET_METADATA_FIELD = SdkField
            .<ResultSetMetadata> builder(MarshallingType.SDK_POJO).getter(getter(ResultSet::resultSetMetadata))
            .setter(setter(Builder::resultSetMetadata)).constructor(ResultSetMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSetMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD,
            RESULT_SET_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Row> rows;

    private final ResultSetMetadata resultSetMetadata;

    private ResultSet(BuilderImpl builder) {
        this.rows = builder.rows;
        this.resultSetMetadata = builder.resultSetMetadata;
    }

    /**
     * Returns true if the Rows property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rows in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rows in the table.
     */
    public List<Row> rows() {
        return rows;
    }

    /**
     * <p>
     * The metadata that describes the column structure and data types of a table of query results.
     * </p>
     * 
     * @return The metadata that describes the column structure and data types of a table of query results.
     */
    public ResultSetMetadata resultSetMetadata() {
        return resultSetMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rows());
        hashCode = 31 * hashCode + Objects.hashCode(resultSetMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet) obj;
        return Objects.equals(rows(), other.rows()) && Objects.equals(resultSetMetadata(), other.resultSetMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResultSet").add("Rows", rows()).add("ResultSetMetadata", resultSetMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "ResultSetMetadata":
            return Optional.ofNullable(clazz.cast(resultSetMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSet, T> g) {
        return obj -> g.apply((ResultSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultSet> {
        /**
         * <p>
         * The rows in the table.
         * </p>
         * 
         * @param rows
         *        The rows in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<Row> rows);

        /**
         * <p>
         * The rows in the table.
         * </p>
         * 
         * @param rows
         *        The rows in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Row... rows);

        /**
         * <p>
         * The rows in the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Row>.Builder} avoiding the need to create
         * one manually via {@link List<Row>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Row>.Builder#build()} is called immediately and its result
         * is passed to {@link #rows(List<Row>)}.
         * 
         * @param rows
         *        a consumer that will call methods on {@link List<Row>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(List<Row>)
         */
        Builder rows(Consumer<Row.Builder>... rows);

        /**
         * <p>
         * The metadata that describes the column structure and data types of a table of query results.
         * </p>
         * 
         * @param resultSetMetadata
         *        The metadata that describes the column structure and data types of a table of query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSetMetadata(ResultSetMetadata resultSetMetadata);

        /**
         * <p>
         * The metadata that describes the column structure and data types of a table of query results.
         * </p>
         * This is a convenience that creates an instance of the {@link ResultSetMetadata.Builder} avoiding the need to
         * create one manually via {@link ResultSetMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResultSetMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #resultSetMetadata(ResultSetMetadata)}.
         * 
         * @param resultSetMetadata
         *        a consumer that will call methods on {@link ResultSetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultSetMetadata(ResultSetMetadata)
         */
        default Builder resultSetMetadata(Consumer<ResultSetMetadata.Builder> resultSetMetadata) {
            return resultSetMetadata(ResultSetMetadata.builder().applyMutation(resultSetMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();

        private ResultSetMetadata resultSetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSet model) {
            rows(model.rows);
            resultSetMetadata(model.resultSetMetadata);
        }

        public final Collection<Row.Builder> getRows() {
            return rows != null ? rows.stream().map(Row::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder>... rows) {
            rows(Stream.of(rows).map(c -> Row.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowListCopier.copyFromBuilder(rows);
        }

        public final ResultSetMetadata.Builder getResultSetMetadata() {
            return resultSetMetadata != null ? resultSetMetadata.toBuilder() : null;
        }

        @Override
        public final Builder resultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
            return this;
        }

        public final void setResultSetMetadata(ResultSetMetadata.BuilderImpl resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata != null ? resultSetMetadata.build() : null;
        }

        @Override
        public ResultSet build() {
            return new ResultSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
