/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the updates in the query results, such as output location and encryption configuration for the
 * query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultConfigurationUpdates implements SdkPojo, Serializable,
        ToCopyableBuilder<ResultConfigurationUpdates.Builder, ResultConfigurationUpdates> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResultConfigurationUpdates::outputLocation)).setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<Boolean> REMOVE_OUTPUT_LOCATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ResultConfigurationUpdates::removeOutputLocation)).setter(setter(Builder::removeOutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOutputLocation").build())
            .build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResultConfigurationUpdates::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<Boolean> REMOVE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ResultConfigurationUpdates::removeEncryptionConfiguration))
            .setter(setter(Builder::removeEncryptionConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEncryptionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD,
            REMOVE_OUTPUT_LOCATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, REMOVE_ENCRYPTION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputLocation;

    private final Boolean removeOutputLocation;

    private final EncryptionConfiguration encryptionConfiguration;

    private final Boolean removeEncryptionConfiguration;

    private ResultConfigurationUpdates(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.removeOutputLocation = builder.removeOutputLocation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.removeEncryptionConfiguration = builder.removeEncryptionConfiguration;
    }

    /**
     * <p>
     * The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code>.
     * For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>
     * If workgroup settings override client-side settings, then the query uses the location for the query results and
     * the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified
     * in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See
     * <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.
     * </p>
     * 
     * @return The location in Amazon S3 where your query results are stored, such as
     *         <code>s3://path/to/query/bucket/</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup settings
     *         override client-side settings, then the query uses the location for the query results and the encryption
     *         configuration that are specified for the workgroup. The "workgroup settings override" is specified in
     *         EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See
     *         <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.
     */
    public String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * If set to "true", indicates that the previously-specified query results location (also known as a client-side
     * setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a
     * value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the
     * OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information,
     * see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     * Override Client-Side Settings</a>.
     * </p>
     * 
     * @return If set to "true", indicates that the previously-specified query results location (also known as a
     *         client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false"
     *         or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side
     *         setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *         Override Client-Side Settings</a>.
     */
    public Boolean removeOutputLocation() {
        return removeOutputLocation;
    }

    /**
     * <p>
     * The encryption configuration for the query results.
     * </p>
     * 
     * @return The encryption configuration for the query results.
     */
    public EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side
     * setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a
     * value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the
     * EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     * 
     * @return If set to "true", indicates that the previously-specified encryption configuration (also known as the
     *         client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false"
     *         or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the
     *         client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated
     *         with the new value. For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *         Override Client-Side Settings</a>.
     */
    public Boolean removeEncryptionConfiguration() {
        return removeEncryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(removeOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(removeEncryptionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfigurationUpdates)) {
            return false;
        }
        ResultConfigurationUpdates other = (ResultConfigurationUpdates) obj;
        return Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(removeOutputLocation(), other.removeOutputLocation())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(removeEncryptionConfiguration(), other.removeEncryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResultConfigurationUpdates").add("OutputLocation", outputLocation())
                .add("RemoveOutputLocation", removeOutputLocation()).add("EncryptionConfiguration", encryptionConfiguration())
                .add("RemoveEncryptionConfiguration", removeEncryptionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "RemoveOutputLocation":
            return Optional.ofNullable(clazz.cast(removeOutputLocation()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "RemoveEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(removeEncryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultConfigurationUpdates, T> g) {
        return obj -> g.apply((ResultConfigurationUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultConfigurationUpdates> {
        /**
         * <p>
         * The location in Amazon S3 where your query results are stored, such as
         * <code>s3://path/to/query/bucket/</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup settings
         * override client-side settings, then the query uses the location for the query results and the encryption
         * configuration that are specified for the workgroup. The "workgroup settings override" is specified in
         * EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See
         * <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.
         * </p>
         * 
         * @param outputLocation
         *        The location in Amazon S3 where your query results are stored, such as
         *        <code>s3://path/to/query/bucket/</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup
         *        settings override client-side settings, then the query uses the location for the query results and the
         *        encryption configuration that are specified for the workgroup. The "workgroup settings override" is
         *        specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See
         *        <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * If set to "true", indicates that the previously-specified query results location (also known as a client-side
         * setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a
         * value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the
         * OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
         * Override Client-Side Settings</a>.
         * </p>
         * 
         * @param removeOutputLocation
         *        If set to "true", indicates that the previously-specified query results location (also known as a
         *        client-side setting) for queries in this workgroup should be ignored and set to null. If set to
         *        "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the
         *        client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with
         *        the new value. For more information, see <a
         *        href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup
         *        Settings Override Client-Side Settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOutputLocation(Boolean removeOutputLocation);

        /**
         * <p>
         * The encryption configuration for the query results.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration for the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration for the query results.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding the
         * need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * If set to "true", indicates that the previously-specified encryption configuration (also known as the
         * client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or
         * not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side
         * setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new
         * value. For more information, see <a
         * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
         * Override Client-Side Settings</a>.
         * </p>
         * 
         * @param removeEncryptionConfiguration
         *        If set to "true", indicates that the previously-specified encryption configuration (also known as the
         *        client-side setting) for queries in this workgroup should be ignored and set to null. If set to
         *        "false" or not set, and a value is present in the EncryptionConfiguration in
         *        ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's
         *        ResultConfiguration will be updated with the new value. For more information, see <a
         *        href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup
         *        Settings Override Client-Side Settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeEncryptionConfiguration(Boolean removeEncryptionConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String outputLocation;

        private Boolean removeOutputLocation;

        private EncryptionConfiguration encryptionConfiguration;

        private Boolean removeEncryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultConfigurationUpdates model) {
            outputLocation(model.outputLocation);
            removeOutputLocation(model.removeOutputLocation);
            encryptionConfiguration(model.encryptionConfiguration);
            removeEncryptionConfiguration(model.removeEncryptionConfiguration);
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        public final Boolean getRemoveOutputLocation() {
            return removeOutputLocation;
        }

        @Override
        public final Builder removeOutputLocation(Boolean removeOutputLocation) {
            this.removeOutputLocation = removeOutputLocation;
            return this;
        }

        public final void setRemoveOutputLocation(Boolean removeOutputLocation) {
            this.removeOutputLocation = removeOutputLocation;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final Boolean getRemoveEncryptionConfiguration() {
            return removeEncryptionConfiguration;
        }

        @Override
        public final Builder removeEncryptionConfiguration(Boolean removeEncryptionConfiguration) {
            this.removeEncryptionConfiguration = removeEncryptionConfiguration;
            return this;
        }

        public final void setRemoveEncryptionConfiguration(Boolean removeEncryptionConfiguration) {
            this.removeEncryptionConfiguration = removeEncryptionConfiguration;
        }

        @Override
        public ResultConfigurationUpdates build() {
            return new ResultConfigurationUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
