/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EncryptionConfigurationMarshaller {
    private static final MarshallingInfo<String> ENCRYPTIONOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionOption").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKey").isBinary(false).build();
    private static final EncryptionConfigurationMarshaller INSTANCE = new EncryptionConfigurationMarshaller();

    private EncryptionConfigurationMarshaller() {
    }

    public static EncryptionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EncryptionConfiguration encryptionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)encryptionConfiguration, (String)"encryptionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)encryptionConfiguration.encryptionOptionString(), ENCRYPTIONOPTION_BINDING);
            protocolMarshaller.marshall((Object)encryptionConfiguration.kmsKey(), KMSKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

