/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ColumnInfoMarshaller {
    private static final MarshallingInfo<String> CATALOGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogName").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEMANAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> LABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Label").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Integer> PRECISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Precision").isBinary(false).build();
    private static final MarshallingInfo<Integer> SCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Scale").isBinary(false).build();
    private static final MarshallingInfo<String> NULLABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Nullable").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CASESENSITIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaseSensitive").isBinary(false).build();
    private static final ColumnInfoMarshaller INSTANCE = new ColumnInfoMarshaller();

    private ColumnInfoMarshaller() {
    }

    public static ColumnInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ColumnInfo columnInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)columnInfo, (String)"columnInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)columnInfo.catalogName(), CATALOGNAME_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.schemaName(), SCHEMANAME_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.label(), LABEL_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.precision(), PRECISION_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.scale(), SCALE_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.nullableString(), NULLABLE_BINDING);
            protocolMarshaller.marshall((Object)columnInfo.caseSensitive(), CASESENSITIVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

