/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.QueryExecutionState;
import software.amazon.awssdk.services.athena.transform.QueryExecutionStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryExecutionStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, QueryExecutionStatus> {
    private final String state;
    private final String stateChangeReason;
    private final Instant submissionDateTime;
    private final Instant completionDateTime;

    private QueryExecutionStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.submissionDateTime = builder.submissionDateTime;
        this.completionDateTime = builder.completionDateTime;
    }

    public QueryExecutionState state() {
        return QueryExecutionState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String stateChangeReason() {
        return this.stateChangeReason;
    }

    public Instant submissionDateTime() {
        return this.submissionDateTime;
    }

    public Instant completionDateTime() {
        return this.completionDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatus)) {
            return false;
        }
        QueryExecutionStatus other = (QueryExecutionStatus)obj;
        return Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.submissionDateTime(), other.submissionDateTime()) && Objects.equals(this.completionDateTime(), other.completionDateTime());
    }

    public String toString() {
        return ToString.builder((String)"QueryExecutionStatus").add("State", (Object)this.stateString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("SubmissionDateTime", (Object)this.submissionDateTime()).add("CompletionDateTime", (Object)this.completionDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
            case "SubmissionDateTime": {
                return Optional.of(clazz.cast(this.submissionDateTime()));
            }
            case "CompletionDateTime": {
                return Optional.of(clazz.cast(this.completionDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String stateChangeReason;
        private Instant submissionDateTime;
        private Instant completionDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.submissionDateTime(model.submissionDateTime);
            this.completionDateTime(model.completionDateTime);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryExecutionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateChangeReason() {
            return this.stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public final Instant getSubmissionDateTime() {
            return this.submissionDateTime;
        }

        @Override
        public final Builder submissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
            return this;
        }

        public final void setSubmissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
        }

        public final Instant getCompletionDateTime() {
            return this.completionDateTime;
        }

        @Override
        public final Builder completionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
            return this;
        }

        public final void setCompletionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
        }

        public QueryExecutionStatus build() {
            return new QueryExecutionStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryExecutionStatus> {
        public Builder state(String var1);

        public Builder state(QueryExecutionState var1);

        public Builder stateChangeReason(String var1);

        public Builder submissionDateTime(Instant var1);

        public Builder completionDateTime(Instant var1);
    }
}

