/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.EncryptionOption;
import software.amazon.awssdk.services.athena.transform.EncryptionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EncryptionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private final String encryptionOption;
    private final String kmsKey;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.encryptionOption = builder.encryptionOption;
        this.kmsKey = builder.kmsKey;
    }

    public EncryptionOption encryptionOption() {
        return EncryptionOption.fromValue(this.encryptionOption);
    }

    public String encryptionOptionString() {
        return this.encryptionOption;
    }

    public String kmsKey() {
        return this.kmsKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionOptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        return Objects.equals(this.encryptionOptionString(), other.encryptionOptionString()) && Objects.equals(this.kmsKey(), other.kmsKey());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionConfiguration").add("EncryptionOption", (Object)this.encryptionOptionString()).add("KmsKey", (Object)this.kmsKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionOption": {
                return Optional.of(clazz.cast(this.encryptionOptionString()));
            }
            case "KmsKey": {
                return Optional.of(clazz.cast(this.kmsKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionOption;
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.encryptionOption(model.encryptionOption);
            this.kmsKey(model.kmsKey);
        }

        public final String getEncryptionOption() {
            return this.encryptionOption;
        }

        @Override
        public final Builder encryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
            return this;
        }

        @Override
        public final Builder encryptionOption(EncryptionOption encryptionOption) {
            this.encryptionOption(encryptionOption.toString());
            return this;
        }

        public final void setEncryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder encryptionOption(String var1);

        public Builder encryptionOption(EncryptionOption var1);

        public Builder kmsKey(String var1);
    }
}

