/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.transform.ColumnInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ColumnInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ColumnInfo> {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String name;
    private final String label;
    private final String type;
    private final Integer precision;
    private final Integer scale;
    private final String nullable;
    private final Boolean caseSensitive;

    private ColumnInfo(BuilderImpl builder) {
        this.catalogName = builder.catalogName;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.name = builder.name;
        this.label = builder.label;
        this.type = builder.type;
        this.precision = builder.precision;
        this.scale = builder.scale;
        this.nullable = builder.nullable;
        this.caseSensitive = builder.caseSensitive;
    }

    public String catalogName() {
        return this.catalogName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tableName;
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public String type() {
        return this.type;
    }

    public Integer precision() {
        return this.precision;
    }

    public Integer scale() {
        return this.scale;
    }

    public ColumnNullable nullable() {
        return ColumnNullable.fromValue(this.nullable);
    }

    public String nullableString() {
        return this.nullable;
    }

    public Boolean caseSensitive() {
        return this.caseSensitive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullableString());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseSensitive());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo other = (ColumnInfo)obj;
        return Objects.equals(this.catalogName(), other.catalogName()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.precision(), other.precision()) && Objects.equals(this.scale(), other.scale()) && Objects.equals(this.nullableString(), other.nullableString()) && Objects.equals(this.caseSensitive(), other.caseSensitive());
    }

    public String toString() {
        return ToString.builder((String)"ColumnInfo").add("CatalogName", (Object)this.catalogName()).add("SchemaName", (Object)this.schemaName()).add("TableName", (Object)this.tableName()).add("Name", (Object)this.name()).add("Label", (Object)this.label()).add("Type", (Object)this.type()).add("Precision", (Object)this.precision()).add("Scale", (Object)this.scale()).add("Nullable", (Object)this.nullableString()).add("CaseSensitive", (Object)this.caseSensitive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogName": {
                return Optional.of(clazz.cast(this.catalogName()));
            }
            case "SchemaName": {
                return Optional.of(clazz.cast(this.schemaName()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Label": {
                return Optional.of(clazz.cast(this.label()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "Precision": {
                return Optional.of(clazz.cast(this.precision()));
            }
            case "Scale": {
                return Optional.of(clazz.cast(this.scale()));
            }
            case "Nullable": {
                return Optional.of(clazz.cast(this.nullableString()));
            }
            case "CaseSensitive": {
                return Optional.of(clazz.cast(this.caseSensitive()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColumnInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogName;
        private String schemaName;
        private String tableName;
        private String name;
        private String label;
        private String type;
        private Integer precision;
        private Integer scale;
        private String nullable;
        private Boolean caseSensitive;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnInfo model) {
            this.catalogName(model.catalogName);
            this.schemaName(model.schemaName);
            this.tableName(model.tableName);
            this.name(model.name);
            this.label(model.label);
            this.type(model.type);
            this.precision(model.precision);
            this.scale(model.scale);
            this.nullable(model.nullable);
            this.caseSensitive(model.caseSensitive);
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getPrecision() {
            return this.precision;
        }

        @Override
        public final Builder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public final void setPrecision(Integer precision) {
            this.precision = precision;
        }

        public final Integer getScale() {
            return this.scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final String getNullable() {
            return this.nullable;
        }

        @Override
        public final Builder nullable(String nullable) {
            this.nullable = nullable;
            return this;
        }

        @Override
        public final Builder nullable(ColumnNullable nullable) {
            this.nullable(nullable.toString());
            return this;
        }

        public final void setNullable(String nullable) {
            this.nullable = nullable;
        }

        public final Boolean getCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public final Builder caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public final void setCaseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ColumnInfo> {
        public Builder catalogName(String var1);

        public Builder schemaName(String var1);

        public Builder tableName(String var1);

        public Builder name(String var1);

        public Builder label(String var1);

        public Builder type(String var1);

        public Builder precision(Integer var1);

        public Builder scale(Integer var1);

        public Builder nullable(String var1);

        public Builder nullable(ColumnNullable var1);

        public Builder caseSensitive(Boolean var1);
    }
}

