/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;

public final class ListNamedQueriesPaginator
implements SdkIterable<ListNamedQueriesResponse> {
    private final AthenaClient client;
    private final ListNamedQueriesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListNamedQueriesPaginator(AthenaClient client, ListNamedQueriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNamedQueriesResponseFetcher();
    }

    public Iterator<ListNamedQueriesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListNamedQueriesResponseFetcher
    implements NextPageFetcher<ListNamedQueriesResponse> {
        private ListNamedQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamedQueriesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListNamedQueriesResponse nextPage(ListNamedQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListNamedQueriesPaginator.this.client.listNamedQueries(ListNamedQueriesPaginator.this.firstRequest);
            }
            return ListNamedQueriesPaginator.this.client.listNamedQueries((ListNamedQueriesRequest)((Object)ListNamedQueriesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

