/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.services.athena.model.Row;
import software.amazon.awssdk.services.athena.model.RowListCopier;
import software.amazon.awssdk.services.athena.transform.ResultSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResultSet
implements StructuredPojo,
ToCopyableBuilder<Builder, ResultSet> {
    private final List<Row> rows;
    private final ResultSetMetadata resultSetMetadata;

    private ResultSet(BuilderImpl builder) {
        this.rows = builder.rows;
        this.resultSetMetadata = builder.resultSetMetadata;
    }

    public List<Row> rows() {
        return this.rows;
    }

    public ResultSetMetadata resultSetMetadata() {
        return this.resultSetMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rows() == null ? 0 : this.rows().hashCode());
        hashCode = 31 * hashCode + (this.resultSetMetadata() == null ? 0 : this.resultSetMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        if (other.rows() == null ^ this.rows() == null) {
            return false;
        }
        if (other.rows() != null && !other.rows().equals(this.rows())) {
            return false;
        }
        if (other.resultSetMetadata() == null ^ this.resultSetMetadata() == null) {
            return false;
        }
        return other.resultSetMetadata() == null || other.resultSetMetadata().equals(this.resultSetMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.rows() != null) {
            sb.append("Rows: ").append(this.rows()).append(",");
        }
        if (this.resultSetMetadata() != null) {
            sb.append("ResultSetMetadata: ").append(this.resultSetMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rows": {
                return Optional.of(clazz.cast(this.rows()));
            }
            case "ResultSetMetadata": {
                return Optional.of(clazz.cast(this.resultSetMetadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Row> rows;
        private ResultSetMetadata resultSetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSet model) {
            this.rows(model.rows);
            this.resultSetMetadata(model.resultSetMetadata);
        }

        public final Collection<Row.Builder> getRows() {
            return this.rows != null ? (Collection)this.rows.stream().map(Row::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowListCopier.copyFromBuilder(rows);
        }

        public final ResultSetMetadata.Builder getResultSetMetadata() {
            return this.resultSetMetadata != null ? this.resultSetMetadata.toBuilder() : null;
        }

        @Override
        public final Builder resultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
            return this;
        }

        public final void setResultSetMetadata(ResultSetMetadata.BuilderImpl resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata != null ? resultSetMetadata.build() : null;
        }

        public ResultSet build() {
            return new ResultSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResultSet> {
        public Builder rows(Collection<Row> var1);

        public Builder rows(Row ... var1);

        public Builder resultSetMetadata(ResultSetMetadata var1);
    }
}

