/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.athena.model.NamedQuery;

public class NamedQueryUnmarshaller
implements Unmarshaller<NamedQuery, JsonUnmarshallerContext> {
    private static final NamedQueryUnmarshaller INSTANCE = new NamedQueryUnmarshaller();

    public NamedQuery unmarshall(JsonUnmarshallerContext context) throws Exception {
        NamedQuery.Builder namedQueryBuilder = NamedQuery.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    namedQueryBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    namedQueryBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Database", targetDepth)) {
                    context.nextToken();
                    namedQueryBuilder.database((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("QueryString", targetDepth)) {
                    context.nextToken();
                    namedQueryBuilder.queryString((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NamedQueryId", targetDepth)) {
                    context.nextToken();
                    namedQueryBuilder.namedQueryId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (NamedQuery)namedQueryBuilder.build();
    }

    public static NamedQueryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

