/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.QueryExecutionState;
import software.amazon.awssdk.services.athena.transform.QueryExecutionStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryExecutionStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, QueryExecutionStatus> {
    private final String state;
    private final String stateChangeReason;
    private final Instant submissionDateTime;
    private final Instant completionDateTime;

    private QueryExecutionStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.submissionDateTime = builder.submissionDateTime;
        this.completionDateTime = builder.completionDateTime;
    }

    public String state() {
        return this.state;
    }

    public String stateChangeReason() {
        return this.stateChangeReason;
    }

    public Instant submissionDateTime() {
        return this.submissionDateTime;
    }

    public Instant completionDateTime() {
        return this.completionDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.stateChangeReason() == null ? 0 : this.stateChangeReason().hashCode());
        hashCode = 31 * hashCode + (this.submissionDateTime() == null ? 0 : this.submissionDateTime().hashCode());
        hashCode = 31 * hashCode + (this.completionDateTime() == null ? 0 : this.completionDateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatus)) {
            return false;
        }
        QueryExecutionStatus other = (QueryExecutionStatus)obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        if (other.stateChangeReason() != null && !other.stateChangeReason().equals(this.stateChangeReason())) {
            return false;
        }
        if (other.submissionDateTime() == null ^ this.submissionDateTime() == null) {
            return false;
        }
        if (other.submissionDateTime() != null && !other.submissionDateTime().equals(this.submissionDateTime())) {
            return false;
        }
        if (other.completionDateTime() == null ^ this.completionDateTime() == null) {
            return false;
        }
        return other.completionDateTime() == null || other.completionDateTime().equals(this.completionDateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (this.submissionDateTime() != null) {
            sb.append("SubmissionDateTime: ").append(this.submissionDateTime()).append(",");
        }
        if (this.completionDateTime() != null) {
            sb.append("CompletionDateTime: ").append(this.completionDateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String state;
        private String stateChangeReason;
        private Instant submissionDateTime;
        private Instant completionDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatus model) {
            this.setState(model.state);
            this.setStateChangeReason(model.stateChangeReason);
            this.setSubmissionDateTime(model.submissionDateTime);
            this.setCompletionDateTime(model.completionDateTime);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryExecutionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateChangeReason() {
            return this.stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public final Instant getSubmissionDateTime() {
            return this.submissionDateTime;
        }

        @Override
        public final Builder submissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
            return this;
        }

        public final void setSubmissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
        }

        public final Instant getCompletionDateTime() {
            return this.completionDateTime;
        }

        @Override
        public final Builder completionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
            return this;
        }

        public final void setCompletionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
        }

        public QueryExecutionStatus build() {
            return new QueryExecutionStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryExecutionStatus> {
        public Builder state(String var1);

        public Builder state(QueryExecutionState var1);

        public Builder stateChangeReason(String var1);

        public Builder submissionDateTime(Instant var1);

        public Builder completionDateTime(Instant var1);
    }
}

