/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.transform.QueryExecutionStatisticsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryExecutionStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, QueryExecutionStatistics> {
    private final Long engineExecutionTimeInMillis;
    private final Long dataScannedInBytes;

    private QueryExecutionStatistics(BuilderImpl builder) {
        this.engineExecutionTimeInMillis = builder.engineExecutionTimeInMillis;
        this.dataScannedInBytes = builder.dataScannedInBytes;
    }

    public Long engineExecutionTimeInMillis() {
        return this.engineExecutionTimeInMillis;
    }

    public Long dataScannedInBytes() {
        return this.dataScannedInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.engineExecutionTimeInMillis() == null ? 0 : this.engineExecutionTimeInMillis().hashCode());
        hashCode = 31 * hashCode + (this.dataScannedInBytes() == null ? 0 : this.dataScannedInBytes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatistics)) {
            return false;
        }
        QueryExecutionStatistics other = (QueryExecutionStatistics)obj;
        if (other.engineExecutionTimeInMillis() == null ^ this.engineExecutionTimeInMillis() == null) {
            return false;
        }
        if (other.engineExecutionTimeInMillis() != null && !other.engineExecutionTimeInMillis().equals(this.engineExecutionTimeInMillis())) {
            return false;
        }
        if (other.dataScannedInBytes() == null ^ this.dataScannedInBytes() == null) {
            return false;
        }
        return other.dataScannedInBytes() == null || other.dataScannedInBytes().equals(this.dataScannedInBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.engineExecutionTimeInMillis() != null) {
            sb.append("EngineExecutionTimeInMillis: ").append(this.engineExecutionTimeInMillis()).append(",");
        }
        if (this.dataScannedInBytes() != null) {
            sb.append("DataScannedInBytes: ").append(this.dataScannedInBytes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long engineExecutionTimeInMillis;
        private Long dataScannedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatistics model) {
            this.setEngineExecutionTimeInMillis(model.engineExecutionTimeInMillis);
            this.setDataScannedInBytes(model.dataScannedInBytes);
        }

        public final Long getEngineExecutionTimeInMillis() {
            return this.engineExecutionTimeInMillis;
        }

        @Override
        public final Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
            return this;
        }

        public final void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
        }

        public final Long getDataScannedInBytes() {
            return this.dataScannedInBytes;
        }

        @Override
        public final Builder dataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
            return this;
        }

        public final void setDataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
        }

        public QueryExecutionStatistics build() {
            return new QueryExecutionStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryExecutionStatistics> {
        public Builder engineExecutionTimeInMillis(Long var1);

        public Builder dataScannedInBytes(Long var1);
    }
}

