/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.transform.NamedQueryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NamedQuery
implements StructuredPojo,
ToCopyableBuilder<Builder, NamedQuery> {
    private final String name;
    private final String description;
    private final String database;
    private final String queryString;
    private final String namedQueryId;

    private NamedQuery(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.database = builder.database;
        this.queryString = builder.queryString;
        this.namedQueryId = builder.namedQueryId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String database() {
        return this.database;
    }

    public String queryString() {
        return this.queryString;
    }

    public String namedQueryId() {
        return this.namedQueryId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.database() == null ? 0 : this.database().hashCode());
        hashCode = 31 * hashCode + (this.queryString() == null ? 0 : this.queryString().hashCode());
        hashCode = 31 * hashCode + (this.namedQueryId() == null ? 0 : this.namedQueryId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedQuery)) {
            return false;
        }
        NamedQuery other = (NamedQuery)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.database() == null ^ this.database() == null) {
            return false;
        }
        if (other.database() != null && !other.database().equals(this.database())) {
            return false;
        }
        if (other.queryString() == null ^ this.queryString() == null) {
            return false;
        }
        if (other.queryString() != null && !other.queryString().equals(this.queryString())) {
            return false;
        }
        if (other.namedQueryId() == null ^ this.namedQueryId() == null) {
            return false;
        }
        return other.namedQueryId() == null || other.namedQueryId().equals(this.namedQueryId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.database() != null) {
            sb.append("Database: ").append(this.database()).append(",");
        }
        if (this.queryString() != null) {
            sb.append("QueryString: ").append(this.queryString()).append(",");
        }
        if (this.namedQueryId() != null) {
            sb.append("NamedQueryId: ").append(this.namedQueryId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NamedQueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String database;
        private String queryString;
        private String namedQueryId;

        private BuilderImpl() {
        }

        private BuilderImpl(NamedQuery model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setDatabase(model.database);
            this.setQueryString(model.queryString);
            this.setNamedQueryId(model.namedQueryId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getNamedQueryId() {
            return this.namedQueryId;
        }

        @Override
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        public NamedQuery build() {
            return new NamedQuery(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NamedQuery> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder database(String var1);

        public Builder queryString(String var1);

        public Builder namedQueryId(String var1);
    }
}

