/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.EncryptionOption;
import software.amazon.awssdk.services.athena.transform.EncryptionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EncryptionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private final String encryptionOption;
    private final String kmsKey;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.encryptionOption = builder.encryptionOption;
        this.kmsKey = builder.kmsKey;
    }

    public String encryptionOption() {
        return this.encryptionOption;
    }

    public String kmsKey() {
        return this.kmsKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.encryptionOption() == null ? 0 : this.encryptionOption().hashCode());
        hashCode = 31 * hashCode + (this.kmsKey() == null ? 0 : this.kmsKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        if (other.encryptionOption() == null ^ this.encryptionOption() == null) {
            return false;
        }
        if (other.encryptionOption() != null && !other.encryptionOption().equals(this.encryptionOption())) {
            return false;
        }
        if (other.kmsKey() == null ^ this.kmsKey() == null) {
            return false;
        }
        return other.kmsKey() == null || other.kmsKey().equals(this.kmsKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.encryptionOption() != null) {
            sb.append("EncryptionOption: ").append(this.encryptionOption()).append(",");
        }
        if (this.kmsKey() != null) {
            sb.append("KmsKey: ").append(this.kmsKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String encryptionOption;
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.setEncryptionOption(model.encryptionOption);
            this.setKmsKey(model.kmsKey);
        }

        public final String getEncryptionOption() {
            return this.encryptionOption;
        }

        @Override
        public final Builder encryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
            return this;
        }

        @Override
        public final Builder encryptionOption(EncryptionOption encryptionOption) {
            this.encryptionOption(encryptionOption.toString());
            return this;
        }

        public final void setEncryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder encryptionOption(String var1);

        public Builder encryptionOption(EncryptionOption var1);

        public Builder kmsKey(String var1);
    }
}

