/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.QueryExecutionListCopier;
import software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId;
import software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetQueryExecutionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetQueryExecutionResponse> {
    private final List<QueryExecution> queryExecutions;
    private final List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds;

    private BatchGetQueryExecutionResponse(BuilderImpl builder) {
        this.queryExecutions = builder.queryExecutions;
        this.unprocessedQueryExecutionIds = builder.unprocessedQueryExecutionIds;
    }

    public List<QueryExecution> queryExecutions() {
        return this.queryExecutions;
    }

    public List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds() {
        return this.unprocessedQueryExecutionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queryExecutions() == null ? 0 : this.queryExecutions().hashCode());
        hashCode = 31 * hashCode + (this.unprocessedQueryExecutionIds() == null ? 0 : this.unprocessedQueryExecutionIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetQueryExecutionResponse)) {
            return false;
        }
        BatchGetQueryExecutionResponse other = (BatchGetQueryExecutionResponse)((Object)obj);
        if (other.queryExecutions() == null ^ this.queryExecutions() == null) {
            return false;
        }
        if (other.queryExecutions() != null && !other.queryExecutions().equals(this.queryExecutions())) {
            return false;
        }
        if (other.unprocessedQueryExecutionIds() == null ^ this.unprocessedQueryExecutionIds() == null) {
            return false;
        }
        return other.unprocessedQueryExecutionIds() == null || other.unprocessedQueryExecutionIds().equals(this.unprocessedQueryExecutionIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queryExecutions() != null) {
            sb.append("QueryExecutions: ").append(this.queryExecutions()).append(",");
        }
        if (this.unprocessedQueryExecutionIds() != null) {
            sb.append("UnprocessedQueryExecutionIds: ").append(this.unprocessedQueryExecutionIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<QueryExecution> queryExecutions;
        private List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetQueryExecutionResponse model) {
            this.setQueryExecutions(model.queryExecutions);
            this.setUnprocessedQueryExecutionIds(model.unprocessedQueryExecutionIds);
        }

        public final Collection<QueryExecution> getQueryExecutions() {
            return this.queryExecutions;
        }

        @Override
        public final Builder queryExecutions(Collection<QueryExecution> queryExecutions) {
            this.queryExecutions = QueryExecutionListCopier.copy(queryExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutions(QueryExecution ... queryExecutions) {
            this.queryExecutions(Arrays.asList(queryExecutions));
            return this;
        }

        public final void setQueryExecutions(Collection<QueryExecution> queryExecutions) {
            this.queryExecutions = QueryExecutionListCopier.copy(queryExecutions);
        }

        public final Collection<UnprocessedQueryExecutionId> getUnprocessedQueryExecutionIds() {
            return this.unprocessedQueryExecutionIds;
        }

        @Override
        public final Builder unprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds = UnprocessedQueryExecutionIdListCopier.copy(unprocessedQueryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedQueryExecutionIds(UnprocessedQueryExecutionId ... unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds(Arrays.asList(unprocessedQueryExecutionIds));
            return this;
        }

        public final void setUnprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds = UnprocessedQueryExecutionIdListCopier.copy(unprocessedQueryExecutionIds);
        }

        public BatchGetQueryExecutionResponse build() {
            return new BatchGetQueryExecutionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetQueryExecutionResponse> {
        public Builder queryExecutions(Collection<QueryExecution> var1);

        public Builder queryExecutions(QueryExecution ... var1);

        public Builder unprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> var1);

        public Builder unprocessedQueryExecutionIds(UnprocessedQueryExecutionId ... var1);
    }
}

