/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.athena.model.ColumnInfo;

public class ColumnInfoUnmarshaller
implements Unmarshaller<ColumnInfo, JsonUnmarshallerContext> {
    private static ColumnInfoUnmarshaller INSTANCE;

    public ColumnInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        ColumnInfo.Builder columnInfoBuilder = ColumnInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CatalogName", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.catalogName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SchemaName", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.schemaName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Label", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.label((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Precision", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.precision((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Scale", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.scale((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Nullable", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.nullable((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CaseSensitive", targetDepth)) {
                    context.nextToken();
                    columnInfoBuilder.caseSensitive((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ColumnInfo)columnInfoBuilder.build();
    }

    public static ColumnInfoUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ColumnInfoUnmarshaller();
        }
        return INSTANCE;
    }
}

