/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.artifact.model.AcceptanceType;
import software.amazon.awssdk.services.artifact.model.PublishedState;
import software.amazon.awssdk.services.artifact.model.UploadState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ReportDetail.getter(ReportDetail::id)).setter(ReportDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ReportDetail.getter(ReportDetail::name)).setter(ReportDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ReportDetail.getter(ReportDetail::description)).setter(ReportDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> PERIOD_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("periodStart").getter(ReportDetail.getter(ReportDetail::periodStart)).setter(ReportDetail.setter(Builder::periodStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodStart").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> PERIOD_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("periodEnd").getter(ReportDetail.getter(ReportDetail::periodEnd)).setter(ReportDetail.setter(Builder::periodEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodEnd").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ReportDetail.getter(ReportDetail::createdAt)).setter(ReportDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(ReportDetail.getter(ReportDetail::lastModifiedAt)).setter(ReportDetail.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deletedAt").getter(ReportDetail.getter(ReportDetail::deletedAt)).setter(ReportDetail.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ReportDetail.getter(ReportDetail::stateAsString)).setter(ReportDetail.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ReportDetail.getter(ReportDetail::arn)).setter(ReportDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("series").getter(ReportDetail.getter(ReportDetail::series)).setter(ReportDetail.setter(Builder::series)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("series").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(ReportDetail.getter(ReportDetail::category)).setter(ReportDetail.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("companyName").getter(ReportDetail.getter(ReportDetail::companyName)).setter(ReportDetail.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("companyName").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productName").getter(ReportDetail.getter(ReportDetail::productName)).setter(ReportDetail.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productName").build()}).build();
    private static final SdkField<String> TERM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("termArn").getter(ReportDetail.getter(ReportDetail::termArn)).setter(ReportDetail.setter(Builder::termArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termArn").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("version").getter(ReportDetail.getter(ReportDetail::version)).setter(ReportDetail.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> ACCEPTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("acceptanceType").getter(ReportDetail.getter(ReportDetail::acceptanceTypeAsString)).setter(ReportDetail.setter(Builder::acceptanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptanceType").build()}).build();
    private static final SdkField<Long> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("sequenceNumber").getter(ReportDetail.getter(ReportDetail::sequenceNumber)).setter(ReportDetail.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceNumber").build()}).build();
    private static final SdkField<String> UPLOAD_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadState").getter(ReportDetail.getter(ReportDetail::uploadStateAsString)).setter(ReportDetail.setter(Builder::uploadState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadState").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ReportDetail.getter(ReportDetail::statusMessage)).setter(ReportDetail.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PERIOD_START_FIELD, PERIOD_END_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, DELETED_AT_FIELD, STATE_FIELD, ARN_FIELD, SERIES_FIELD, CATEGORY_FIELD, COMPANY_NAME_FIELD, PRODUCT_NAME_FIELD, TERM_ARN_FIELD, VERSION_FIELD, ACCEPTANCE_TYPE_FIELD, SEQUENCE_NUMBER_FIELD, UPLOAD_STATE_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final Instant periodStart;
    private final Instant periodEnd;
    private final Instant createdAt;
    private final Instant lastModifiedAt;
    private final Instant deletedAt;
    private final String state;
    private final String arn;
    private final String series;
    private final String category;
    private final String companyName;
    private final String productName;
    private final String termArn;
    private final Long version;
    private final String acceptanceType;
    private final Long sequenceNumber;
    private final String uploadState;
    private final String statusMessage;

    private ReportDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.periodStart = builder.periodStart;
        this.periodEnd = builder.periodEnd;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.deletedAt = builder.deletedAt;
        this.state = builder.state;
        this.arn = builder.arn;
        this.series = builder.series;
        this.category = builder.category;
        this.companyName = builder.companyName;
        this.productName = builder.productName;
        this.termArn = builder.termArn;
        this.version = builder.version;
        this.acceptanceType = builder.acceptanceType;
        this.sequenceNumber = builder.sequenceNumber;
        this.uploadState = builder.uploadState;
        this.statusMessage = builder.statusMessage;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant periodStart() {
        return this.periodStart;
    }

    public final Instant periodEnd() {
        return this.periodEnd;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public final PublishedState state() {
        return PublishedState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final String series() {
        return this.series;
    }

    public final String category() {
        return this.category;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final String productName() {
        return this.productName;
    }

    public final String termArn() {
        return this.termArn;
    }

    public final Long version() {
        return this.version;
    }

    public final AcceptanceType acceptanceType() {
        return AcceptanceType.fromValue(this.acceptanceType);
    }

    public final String acceptanceTypeAsString() {
        return this.acceptanceType;
    }

    public final Long sequenceNumber() {
        return this.sequenceNumber;
    }

    public final UploadState uploadState() {
        return UploadState.fromValue(this.uploadState);
    }

    public final String uploadStateAsString() {
        return this.uploadState;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.series());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.termArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDetail)) {
            return false;
        }
        ReportDetail other = (ReportDetail)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.periodStart(), other.periodStart()) && Objects.equals(this.periodEnd(), other.periodEnd()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.deletedAt(), other.deletedAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.series(), other.series()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.termArn(), other.termArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.acceptanceTypeAsString(), other.acceptanceTypeAsString()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.uploadStateAsString(), other.uploadStateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ReportDetail").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("PeriodStart", (Object)this.periodStart()).add("PeriodEnd", (Object)this.periodEnd()).add("CreatedAt", (Object)this.createdAt()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("DeletedAt", (Object)this.deletedAt()).add("State", (Object)this.stateAsString()).add("Arn", (Object)this.arn()).add("Series", (Object)this.series()).add("Category", (Object)this.category()).add("CompanyName", (Object)this.companyName()).add("ProductName", (Object)this.productName()).add("TermArn", (Object)this.termArn()).add("Version", (Object)this.version()).add("AcceptanceType", (Object)this.acceptanceTypeAsString()).add("SequenceNumber", (Object)this.sequenceNumber()).add("UploadState", (Object)this.uploadStateAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "periodStart": {
                return Optional.ofNullable(clazz.cast(this.periodStart()));
            }
            case "periodEnd": {
                return Optional.ofNullable(clazz.cast(this.periodEnd()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "deletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "series": {
                return Optional.ofNullable(clazz.cast(this.series()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "companyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "productName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "termArn": {
                return Optional.ofNullable(clazz.cast(this.termArn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "acceptanceType": {
                return Optional.ofNullable(clazz.cast(this.acceptanceTypeAsString()));
            }
            case "sequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "uploadState": {
                return Optional.ofNullable(clazz.cast(this.uploadStateAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("periodStart", PERIOD_START_FIELD);
        map.put("periodEnd", PERIOD_END_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("deletedAt", DELETED_AT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("series", SERIES_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("companyName", COMPANY_NAME_FIELD);
        map.put("productName", PRODUCT_NAME_FIELD);
        map.put("termArn", TERM_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("acceptanceType", ACCEPTANCE_TYPE_FIELD);
        map.put("sequenceNumber", SEQUENCE_NUMBER_FIELD);
        map.put("uploadState", UPLOAD_STATE_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportDetail, T> g) {
        return obj -> g.apply((ReportDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private Instant periodStart;
        private Instant periodEnd;
        private Instant createdAt;
        private Instant lastModifiedAt;
        private Instant deletedAt;
        private String state;
        private String arn;
        private String series;
        private String category;
        private String companyName;
        private String productName;
        private String termArn;
        private Long version;
        private String acceptanceType;
        private Long sequenceNumber;
        private String uploadState;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDetail model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.periodStart(model.periodStart);
            this.periodEnd(model.periodEnd);
            this.createdAt(model.createdAt);
            this.lastModifiedAt(model.lastModifiedAt);
            this.deletedAt(model.deletedAt);
            this.state(model.state);
            this.arn(model.arn);
            this.series(model.series);
            this.category(model.category);
            this.companyName(model.companyName);
            this.productName(model.productName);
            this.termArn(model.termArn);
            this.version(model.version);
            this.acceptanceType(model.acceptanceType);
            this.sequenceNumber(model.sequenceNumber);
            this.uploadState(model.uploadState);
            this.statusMessage(model.statusMessage);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getPeriodStart() {
            return this.periodStart;
        }

        public final void setPeriodStart(Instant periodStart) {
            this.periodStart = periodStart;
        }

        @Override
        public final Builder periodStart(Instant periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        public final Instant getPeriodEnd() {
            return this.periodEnd;
        }

        public final void setPeriodEnd(Instant periodEnd) {
            this.periodEnd = periodEnd;
        }

        @Override
        public final Builder periodEnd(Instant periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PublishedState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSeries() {
            return this.series;
        }

        public final void setSeries(String series) {
            this.series = series;
        }

        @Override
        public final Builder series(String series) {
            this.series = series;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getTermArn() {
            return this.termArn;
        }

        public final void setTermArn(String termArn) {
            this.termArn = termArn;
        }

        @Override
        public final Builder termArn(String termArn) {
            this.termArn = termArn;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getAcceptanceType() {
            return this.acceptanceType;
        }

        public final void setAcceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
        }

        @Override
        public final Builder acceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
            return this;
        }

        @Override
        public final Builder acceptanceType(AcceptanceType acceptanceType) {
            this.acceptanceType(acceptanceType == null ? null : acceptanceType.toString());
            return this;
        }

        public final Long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final String getUploadState() {
            return this.uploadState;
        }

        public final void setUploadState(String uploadState) {
            this.uploadState = uploadState;
        }

        @Override
        public final Builder uploadState(String uploadState) {
            this.uploadState = uploadState;
            return this;
        }

        @Override
        public final Builder uploadState(UploadState uploadState) {
            this.uploadState(uploadState == null ? null : uploadState.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public ReportDetail build() {
            return new ReportDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportDetail> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder periodStart(Instant var1);

        public Builder periodEnd(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder deletedAt(Instant var1);

        public Builder state(String var1);

        public Builder state(PublishedState var1);

        public Builder arn(String var1);

        public Builder series(String var1);

        public Builder category(String var1);

        public Builder companyName(String var1);

        public Builder productName(String var1);

        public Builder termArn(String var1);

        public Builder version(Long var1);

        public Builder acceptanceType(String var1);

        public Builder acceptanceType(AcceptanceType var1);

        public Builder sequenceNumber(Long var1);

        public Builder uploadState(String var1);

        public Builder uploadState(UploadState var1);

        public Builder statusMessage(String var1);
    }
}

