/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartZonalShiftRequest
extends ArcZonalShiftRequest
implements ToCopyableBuilder<Builder, StartZonalShiftRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceIdentifier").getter(StartZonalShiftRequest.getter(StartZonalShiftRequest::resourceIdentifier)).setter(StartZonalShiftRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awayFrom").getter(StartZonalShiftRequest.getter(StartZonalShiftRequest::awayFrom)).setter(StartZonalShiftRequest.setter(Builder::awayFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()}).build();
    private static final SdkField<String> EXPIRES_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expiresIn").getter(StartZonalShiftRequest.getter(StartZonalShiftRequest::expiresIn)).setter(StartZonalShiftRequest.setter(Builder::expiresIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(StartZonalShiftRequest.getter(StartZonalShiftRequest::comment)).setter(StartZonalShiftRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, AWAY_FROM_FIELD, EXPIRES_IN_FIELD, COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartZonalShiftRequest.memberNameToFieldInitializer();
    private final String resourceIdentifier;
    private final String awayFrom;
    private final String expiresIn;
    private final String comment;

    private StartZonalShiftRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.awayFrom = builder.awayFrom;
        this.expiresIn = builder.expiresIn;
        this.comment = builder.comment;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final String awayFrom() {
        return this.awayFrom;
    }

    public final String expiresIn() {
        return this.expiresIn;
    }

    public final String comment() {
        return this.comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartZonalShiftRequest)) {
            return false;
        }
        StartZonalShiftRequest other = (StartZonalShiftRequest)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.awayFrom(), other.awayFrom()) && Objects.equals(this.expiresIn(), other.expiresIn()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"StartZonalShiftRequest").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("AwayFrom", (Object)this.awayFrom()).add("ExpiresIn", (Object)this.expiresIn()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "awayFrom": {
                return Optional.ofNullable(clazz.cast(this.awayFrom()));
            }
            case "expiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("awayFrom", AWAY_FROM_FIELD);
        map.put("expiresIn", EXPIRES_IN_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartZonalShiftRequest, T> g) {
        return obj -> g.apply((StartZonalShiftRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcZonalShiftRequest.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String awayFrom;
        private String expiresIn;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(StartZonalShiftRequest model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.awayFrom(model.awayFrom);
            this.expiresIn(model.expiresIn);
            this.comment(model.comment);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getAwayFrom() {
            return this.awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final String getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartZonalShiftRequest build() {
            return new StartZonalShiftRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcZonalShiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartZonalShiftRequest> {
        public Builder resourceIdentifier(String var1);

        public Builder awayFrom(String var1);

        public Builder expiresIn(String var1);

        public Builder comment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

