/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateZonalShiftResponse
extends ArcZonalShiftResponse
implements ToCopyableBuilder<Builder, UpdateZonalShiftResponse> {
    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awayFrom").getter(UpdateZonalShiftResponse.getter(UpdateZonalShiftResponse::awayFrom)).setter(UpdateZonalShiftResponse.setter(Builder::awayFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(UpdateZonalShiftResponse.getter(UpdateZonalShiftResponse::comment)).setter(UpdateZonalShiftResponse.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiryTime").getter(UpdateZonalShiftResponse.getter(UpdateZonalShiftResponse::expiryTime)).setter(UpdateZonalShiftResponse.setter(Builder::expiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceIdentifier").getter(UpdateZonalShiftResponse.getter(UpdateZonalShiftResponse::resourceIdentifier)).setter(UpdateZonalShiftResponse.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(UpdateZonalShiftResponse.getter(UpdateZonalShiftResponse::startTime)).setter(UpdateZonalShiftResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateZonalShiftResponse.getter(UpdateZonalShiftResponse::statusAsString)).setter(UpdateZonalShiftResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ZONAL_SHIFT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zonalShiftId").getter(UpdateZonalShiftResponse.getter(UpdateZonalShiftResponse::zonalShiftId)).setter(UpdateZonalShiftResponse.setter(Builder::zonalShiftId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWAY_FROM_FIELD, COMMENT_FIELD, EXPIRY_TIME_FIELD, RESOURCE_IDENTIFIER_FIELD, START_TIME_FIELD, STATUS_FIELD, ZONAL_SHIFT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateZonalShiftResponse.memberNameToFieldInitializer();
    private final String awayFrom;
    private final String comment;
    private final Instant expiryTime;
    private final String resourceIdentifier;
    private final Instant startTime;
    private final String status;
    private final String zonalShiftId;

    private UpdateZonalShiftResponse(BuilderImpl builder) {
        super(builder);
        this.awayFrom = builder.awayFrom;
        this.comment = builder.comment;
        this.expiryTime = builder.expiryTime;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.zonalShiftId = builder.zonalShiftId;
    }

    public final String awayFrom() {
        return this.awayFrom;
    }

    public final String comment() {
        return this.comment;
    }

    public final Instant expiryTime() {
        return this.expiryTime;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final ZonalShiftStatus status() {
        return ZonalShiftStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String zonalShiftId() {
        return this.zonalShiftId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalShiftId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateZonalShiftResponse)) {
            return false;
        }
        UpdateZonalShiftResponse other = (UpdateZonalShiftResponse)((Object)obj);
        return Objects.equals(this.awayFrom(), other.awayFrom()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.expiryTime(), other.expiryTime()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.zonalShiftId(), other.zonalShiftId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateZonalShiftResponse").add("AwayFrom", (Object)this.awayFrom()).add("Comment", (Object)this.comment()).add("ExpiryTime", (Object)this.expiryTime()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("ZonalShiftId", (Object)this.zonalShiftId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awayFrom": {
                return Optional.ofNullable(clazz.cast(this.awayFrom()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "expiryTime": {
                return Optional.ofNullable(clazz.cast(this.expiryTime()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "zonalShiftId": {
                return Optional.ofNullable(clazz.cast(this.zonalShiftId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awayFrom", AWAY_FROM_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("expiryTime", EXPIRY_TIME_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("zonalShiftId", ZONAL_SHIFT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateZonalShiftResponse, T> g) {
        return obj -> g.apply((UpdateZonalShiftResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcZonalShiftResponse.BuilderImpl
    implements Builder {
        private String awayFrom;
        private String comment;
        private Instant expiryTime;
        private String resourceIdentifier;
        private Instant startTime;
        private String status;
        private String zonalShiftId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateZonalShiftResponse model) {
            super(model);
            this.awayFrom(model.awayFrom);
            this.comment(model.comment);
            this.expiryTime(model.expiryTime);
            this.resourceIdentifier(model.resourceIdentifier);
            this.startTime(model.startTime);
            this.status(model.status);
            this.zonalShiftId(model.zonalShiftId);
        }

        public final String getAwayFrom() {
            return this.awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getExpiryTime() {
            return this.expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ZonalShiftStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getZonalShiftId() {
            return this.zonalShiftId;
        }

        public final void setZonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
        }

        @Override
        public final Builder zonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
            return this;
        }

        @Override
        public UpdateZonalShiftResponse build() {
            return new UpdateZonalShiftResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ArcZonalShiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateZonalShiftResponse> {
        public Builder awayFrom(String var1);

        public Builder comment(String var1);

        public Builder expiryTime(Instant var1);

        public Builder resourceIdentifier(String var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ZonalShiftStatus var1);

        public Builder zonalShiftId(String var1);
    }
}

