/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoshiftSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoshiftSummary> {
    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awayFrom").getter(AutoshiftSummary.getter(AutoshiftSummary::awayFrom)).setter(AutoshiftSummary.setter(Builder::awayFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AutoshiftSummary.getter(AutoshiftSummary::endTime)).setter(AutoshiftSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AutoshiftSummary.getter(AutoshiftSummary::startTime)).setter(AutoshiftSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AutoshiftSummary.getter(AutoshiftSummary::statusAsString)).setter(AutoshiftSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWAY_FROM_FIELD, END_TIME_FIELD, START_TIME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("awayFrom", AWAY_FROM_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String awayFrom;
    private final Instant endTime;
    private final Instant startTime;
    private final String status;

    private AutoshiftSummary(BuilderImpl builder) {
        this.awayFrom = builder.awayFrom;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public final String awayFrom() {
        return this.awayFrom;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final AutoshiftExecutionStatus status() {
        return AutoshiftExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoshiftSummary)) {
            return false;
        }
        AutoshiftSummary other = (AutoshiftSummary)obj;
        return Objects.equals(this.awayFrom(), other.awayFrom()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutoshiftSummary").add("AwayFrom", (Object)this.awayFrom()).add("EndTime", (Object)this.endTime()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awayFrom": {
                return Optional.ofNullable(clazz.cast(this.awayFrom()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutoshiftSummary, T> g) {
        return obj -> g.apply((AutoshiftSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awayFrom;
        private Instant endTime;
        private Instant startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoshiftSummary model) {
            this.awayFrom(model.awayFrom);
            this.endTime(model.endTime);
            this.startTime(model.startTime);
            this.status(model.status);
        }

        public final String getAwayFrom() {
            return this.awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutoshiftExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public AutoshiftSummary build() {
            return new AutoshiftSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoshiftSummary> {
        public Builder awayFrom(String var1);

        public Builder endTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AutoshiftExecutionStatus var1);
    }
}

