/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentDbDefaultBehavior {
    SWITCHOVER_ONLY("switchoverOnly"),
    FAILOVER("failover"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentDbDefaultBehavior> VALUE_MAP;
    private final String value;

    private DocumentDbDefaultBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentDbDefaultBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentDbDefaultBehavior> knownValues() {
        EnumSet<DocumentDbDefaultBehavior> knownValues = EnumSet.allOf(DocumentDbDefaultBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentDbDefaultBehavior.class, DocumentDbDefaultBehavior::toString);
    }
}

