/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchRequest;
import software.amazon.awssdk.services.arcregionswitch.model.AssociatedAlarm;
import software.amazon.awssdk.services.arcregionswitch.model.AssociatedAlarmMapCopier;
import software.amazon.awssdk.services.arcregionswitch.model.ReportConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.Trigger;
import software.amazon.awssdk.services.arcregionswitch.model.TriggerListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.Workflow;
import software.amazon.awssdk.services.arcregionswitch.model.WorkflowListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePlanRequest
extends ArcRegionSwitchRequest
implements ToCopyableBuilder<Builder, UpdatePlanRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdatePlanRequest.getter(UpdatePlanRequest::arn)).setter(UpdatePlanRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdatePlanRequest.getter(UpdatePlanRequest::description)).setter(UpdatePlanRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflows").getter(UpdatePlanRequest.getter(UpdatePlanRequest::workflows)).setter(UpdatePlanRequest.setter(Builder::workflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workflow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(UpdatePlanRequest.getter(UpdatePlanRequest::executionRole)).setter(UpdatePlanRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recoveryTimeObjectiveMinutes").getter(UpdatePlanRequest.getter(UpdatePlanRequest::recoveryTimeObjectiveMinutes)).setter(UpdatePlanRequest.setter(Builder::recoveryTimeObjectiveMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes").build()}).build();
    private static final SdkField<Map<String, AssociatedAlarm>> ASSOCIATED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("associatedAlarms").getter(UpdatePlanRequest.getter(UpdatePlanRequest::associatedAlarms)).setter(UpdatePlanRequest.setter(Builder::associatedAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAlarms").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedAlarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggers").getter(UpdatePlanRequest.getter(UpdatePlanRequest::triggers)).setter(UpdatePlanRequest.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReportConfiguration> REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reportConfiguration").getter(UpdatePlanRequest.getter(UpdatePlanRequest::reportConfiguration)).setter(UpdatePlanRequest.setter(Builder::reportConfiguration)).constructor(ReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, WORKFLOWS_FIELD, EXECUTION_ROLE_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD, ASSOCIATED_ALARMS_FIELD, TRIGGERS_FIELD, REPORT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePlanRequest.memberNameToFieldInitializer();
    private final String arn;
    private final String description;
    private final List<Workflow> workflows;
    private final String executionRole;
    private final Integer recoveryTimeObjectiveMinutes;
    private final Map<String, AssociatedAlarm> associatedAlarms;
    private final List<Trigger> triggers;
    private final ReportConfiguration reportConfiguration;

    private UpdatePlanRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
        this.associatedAlarms = builder.associatedAlarms;
        this.triggers = builder.triggers;
        this.reportConfiguration = builder.reportConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasWorkflows() {
        return this.workflows != null && !(this.workflows instanceof SdkAutoConstructList);
    }

    public final List<Workflow> workflows() {
        return this.workflows;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Integer recoveryTimeObjectiveMinutes() {
        return this.recoveryTimeObjectiveMinutes;
    }

    public final boolean hasAssociatedAlarms() {
        return this.associatedAlarms != null && !(this.associatedAlarms instanceof SdkAutoConstructMap);
    }

    public final Map<String, AssociatedAlarm> associatedAlarms() {
        return this.associatedAlarms;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<Trigger> triggers() {
        return this.triggers;
    }

    public final ReportConfiguration reportConfiguration() {
        return this.reportConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflows() ? this.workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryTimeObjectiveMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedAlarms() ? this.associatedAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlanRequest)) {
            return false;
        }
        UpdatePlanRequest other = (UpdatePlanRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasWorkflows() == other.hasWorkflows() && Objects.equals(this.workflows(), other.workflows()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes()) && this.hasAssociatedAlarms() == other.hasAssociatedAlarms() && Objects.equals(this.associatedAlarms(), other.associatedAlarms()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers()) && Objects.equals(this.reportConfiguration(), other.reportConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePlanRequest").add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Workflows", this.hasWorkflows() ? this.workflows() : null).add("ExecutionRole", (Object)this.executionRole()).add("RecoveryTimeObjectiveMinutes", (Object)this.recoveryTimeObjectiveMinutes()).add("AssociatedAlarms", this.hasAssociatedAlarms() ? this.associatedAlarms() : null).add("Triggers", this.hasTriggers() ? this.triggers() : null).add("ReportConfiguration", (Object)this.reportConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "workflows": {
                return Optional.ofNullable(clazz.cast(this.workflows()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "recoveryTimeObjectiveMinutes": {
                return Optional.ofNullable(clazz.cast(this.recoveryTimeObjectiveMinutes()));
            }
            case "associatedAlarms": {
                return Optional.ofNullable(clazz.cast(this.associatedAlarms()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
            case "reportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.reportConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("workflows", WORKFLOWS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        map.put("associatedAlarms", ASSOCIATED_ALARMS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        map.put("reportConfiguration", REPORT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlanRequest, T> g) {
        return obj -> g.apply((UpdatePlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();
        private String executionRole;
        private Integer recoveryTimeObjectiveMinutes;
        private Map<String, AssociatedAlarm> associatedAlarms = DefaultSdkAutoConstructMap.getInstance();
        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();
        private ReportConfiguration reportConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlanRequest model) {
            super(model);
            this.arn(model.arn);
            this.description(model.description);
            this.workflows(model.workflows);
            this.executionRole(model.executionRole);
            this.recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
            this.associatedAlarms(model.associatedAlarms);
            this.triggers(model.triggers);
            this.reportConfiguration(model.reportConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow ... workflows) {
            this.workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder> ... workflows) {
            this.workflows(Stream.of(workflows).map(c -> (Workflow)((Workflow.Builder)Workflow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return this.recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        public final Map<String, AssociatedAlarm.Builder> getAssociatedAlarms() {
            Map<String, AssociatedAlarm.Builder> result = AssociatedAlarmMapCopier.copyToBuilder(this.associatedAlarms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAlarms(Map<String, AssociatedAlarm.BuilderImpl> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copyFromBuilder(associatedAlarms);
        }

        @Override
        public final Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copy(associatedAlarms);
            return this;
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (Trigger)((Trigger.Builder)Trigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ReportConfiguration.Builder getReportConfiguration() {
            return this.reportConfiguration != null ? this.reportConfiguration.toBuilder() : null;
        }

        public final void setReportConfiguration(ReportConfiguration.BuilderImpl reportConfiguration) {
            this.reportConfiguration = reportConfiguration != null ? reportConfiguration.build() : null;
        }

        @Override
        public final Builder reportConfiguration(ReportConfiguration reportConfiguration) {
            this.reportConfiguration = reportConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlanRequest build() {
            return new UpdatePlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePlanRequest> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder workflows(Collection<Workflow> var1);

        public Builder workflows(Workflow ... var1);

        public Builder workflows(Consumer<Workflow.Builder> ... var1);

        public Builder executionRole(String var1);

        public Builder recoveryTimeObjectiveMinutes(Integer var1);

        public Builder associatedAlarms(Map<String, AssociatedAlarm> var1);

        public Builder triggers(Collection<Trigger> var1);

        public Builder triggers(Trigger ... var1);

        public Builder triggers(Consumer<Trigger.Builder> ... var1);

        public Builder reportConfiguration(ReportConfiguration var1);

        default public Builder reportConfiguration(Consumer<ReportConfiguration.Builder> reportConfiguration) {
            return this.reportConfiguration((ReportConfiguration)((ReportConfiguration.Builder)ReportConfiguration.builder().applyMutation(reportConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

