/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.S3ReportOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportOutputConfiguration> {
    private static final SdkField<S3ReportOutputConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Configuration").getter(ReportOutputConfiguration.getter(ReportOutputConfiguration::s3Configuration)).setter(ReportOutputConfiguration.setter(Builder::s3Configuration)).constructor(S3ReportOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3ReportOutputConfiguration s3Configuration;
    private final Type type;

    private ReportOutputConfiguration(BuilderImpl builder) {
        this.s3Configuration = builder.s3Configuration;
        this.type = builder.type;
    }

    public final S3ReportOutputConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportOutputConfiguration)) {
            return false;
        }
        ReportOutputConfiguration other = (ReportOutputConfiguration)obj;
        return Objects.equals(this.s3Configuration(), other.s3Configuration());
    }

    public final String toString() {
        return ToString.builder((String)"ReportOutputConfiguration").add("S3Configuration", (Object)this.s3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
        }
        return Optional.empty();
    }

    public static ReportOutputConfiguration fromS3Configuration(S3ReportOutputConfiguration s3Configuration) {
        return (ReportOutputConfiguration)ReportOutputConfiguration.builder().s3Configuration(s3Configuration).build();
    }

    public static ReportOutputConfiguration fromS3Configuration(Consumer<S3ReportOutputConfiguration.Builder> s3Configuration) {
        S3ReportOutputConfiguration.Builder builder = S3ReportOutputConfiguration.builder();
        s3Configuration.accept(builder);
        return ReportOutputConfiguration.fromS3Configuration((S3ReportOutputConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<S3ReportOutputConfiguration>> map = new HashMap<String, SdkField<S3ReportOutputConfiguration>>();
        map.put("s3Configuration", S3_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportOutputConfiguration, T> g) {
        return obj -> g.apply((ReportOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3ReportOutputConfiguration s3Configuration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReportOutputConfiguration model) {
            this.s3Configuration(model.s3Configuration);
        }

        public final S3ReportOutputConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3ReportOutputConfiguration.BuilderImpl s3Configuration) {
            S3ReportOutputConfiguration oldValue = this.s3Configuration;
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
            this.handleUnionValueChange(Type.S3_CONFIGURATION, oldValue, this.s3Configuration);
        }

        @Override
        public final Builder s3Configuration(S3ReportOutputConfiguration s3Configuration) {
            S3ReportOutputConfiguration oldValue = this.s3Configuration;
            this.s3Configuration = s3Configuration;
            this.handleUnionValueChange(Type.S3_CONFIGURATION, oldValue, this.s3Configuration);
            return this;
        }

        public ReportOutputConfiguration build() {
            return new ReportOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportOutputConfiguration> {
        public Builder s3Configuration(S3ReportOutputConfiguration var1);

        default public Builder s3Configuration(Consumer<S3ReportOutputConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3ReportOutputConfiguration)((S3ReportOutputConfiguration.Builder)S3ReportOutputConfiguration.builder().applyMutation(s3Configuration)).build());
        }
    }
}

